/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.cornucopia.item;

import com.bmt.cornucopia.Config;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CornucopiaItem
extends Item {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int ITEM_NAME_COLOR = Mth.m_14159_((float)0.133f, (float)0.545f, (float)0.133f);
    private static final int REDUCE_TIME = 6;
    private int suitableFoodIndex = 0;
    private ItemStack suitableFood = ItemStack.f_41583_;

    public CornucopiaItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return Component.m_237115_((String)super.m_7626_(stack).getString()).m_130938_(style -> style.m_178520_(ITEM_NAME_COLOR));
    }

    public static float getWeightDisplay(ItemStack stack) {
        return (float)CornucopiaItem.getContentWeight(stack) / (float)CornucopiaItem.getMaxCapacity();
    }

    private static int getMaxCapacity() {
        return (Integer)Config.COMMON.cornucopiaCapacity.get();
    }

    private static int add(ItemStack pBundleStack, ItemStack pInsertedStack) {
        if (!pInsertedStack.m_41619_() && pInsertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = pBundleStack.m_41784_();
            if (!compoundtag.m_128441_("Items")) {
                compoundtag.m_128365_("Items", (Tag)new ListTag());
            }
            int i = CornucopiaItem.getContentWeight(pBundleStack);
            int j = CornucopiaItem.getWeight(pInsertedStack);
            int k = Math.min(pInsertedStack.m_41613_(), (CornucopiaItem.getMaxCapacity() - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            Optional<CompoundTag> optional = CornucopiaItem.getMatchingItem(pInsertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundTag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundTag1);
                if (k + itemstack.m_41613_() > 64) {
                    int increment = 64 - itemstack.m_41613_();
                    int rest = k - increment;
                    itemstack.m_41769_(increment);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                    ItemStack itemstack1 = pInsertedStack.m_255036_(rest);
                    listtag.add(0, (Tag)itemstack1.m_41739_(new CompoundTag()));
                } else if (k + itemstack.m_41613_() <= 64) {
                    itemstack.m_41769_(k);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                }
            } else {
                ItemStack itemstack1 = pInsertedStack.m_255036_(k);
                CompoundTag compoundTag2 = new CompoundTag();
                itemstack1.m_41739_(compoundTag2);
                listtag.add(0, (Tag)compoundTag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack pStack, ListTag pList) {
        return pList.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)pStack)).findFirst();
    }

    private static int getWeight(ItemStack pStack) {
        return 64 / pStack.m_41741_();
    }

    private static int getContentWeight(ItemStack pStack) {
        return CornucopiaItem.getContents(pStack).mapToInt(itemStack -> CornucopiaItem.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    private static Optional<ItemStack> removeOneStack(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            pStack.m_41749_("Items");
        }
        return Optional.of(itemstack);
    }

    private static Optional<ItemStack> removeOneItem(ItemStack pStack, int index) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        ItemStack restItem = ItemStack.m_41712_((CompoundTag)listtag.m_128728_(index));
        listtag.remove(index);
        ItemStack removedItem = restItem.m_41620_(1);
        if (restItem.m_41613_() != 0) {
            listtag.add(index, (Tag)restItem.m_41739_(new CompoundTag()));
        }
        if (listtag.isEmpty()) {
            pStack.m_41749_("Items");
        }
        return Optional.of(removedItem);
    }

    private static Optional<ItemStack> getItemStackCopy(ItemStack pStack, int index) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)listtag.m_128728_(index));
        return Optional.of(itemStack);
    }

    private static Stream<ItemStack> getContents(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private void updateSuitableFood(ItemStack cornucopia) {
        CornucopiaItem.getItemStackCopy(cornucopia, 0).ifPresentOrElse(itemStack -> {
            this.suitableFood = itemStack;
        }, () -> {
            this.suitableFood = ItemStack.f_41583_;
        });
    }

    public boolean m_142207_(ItemStack pStack, @NotNull Slot pSlot, @NotNull ClickAction pAction, @NotNull Player pPlayer) {
        if (pStack.m_41613_() != 1 || pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)pPlayer);
            CornucopiaItem.removeOneStack(pStack).ifPresent(itemStack -> CornucopiaItem.add(pStack, pSlot.m_150659_(itemStack)));
        } else if (itemstack.m_41720_().m_142095_() && itemstack.m_41614_()) {
            int i = (CornucopiaItem.getMaxCapacity() - CornucopiaItem.getContentWeight(pStack)) / CornucopiaItem.getWeight(itemstack);
            int j = CornucopiaItem.add(pStack, pSlot.m_150647_(itemstack.m_41613_(), i, pPlayer));
            if (j > 0) {
                this.playInsertSound((Entity)pPlayer);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack pStack, @NotNull ItemStack pOther, @NotNull Slot pSlot, @NotNull ClickAction pAction, @NotNull Player pPlayer, @NotNull SlotAccess pAccess) {
        if (pStack.m_41613_() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            int i;
            if (pOther.m_41619_()) {
                CornucopiaItem.removeOneStack(pStack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(itemStack);
                });
            } else if (pOther.m_41614_() && (i = CornucopiaItem.add(pStack, pOther)) > 0) {
                this.playInsertSound((Entity)pPlayer);
                pOther.m_41774_(i);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack cornucopia = pPlayer.m_21120_(pUsedHand);
        CompoundTag compoundtag = cornucopia.m_41784_();
        this.updateSuitableFood(cornucopia);
        if (!compoundtag.m_128441_("Items")) {
            return InteractionResultHolder.m_19098_((Object)cornucopia);
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)cornucopia);
        }
        if (pPlayer.m_36324_().m_38721_() || Objects.requireNonNull(this.suitableFood.getFoodProperties((LivingEntity)pPlayer)).m_38747_()) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)cornucopia);
        }
        return InteractionResultHolder.m_19100_((Object)cornucopia);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        ItemStack foodCopy = this.suitableFood.m_41777_();
        ItemStack originalFood = this.suitableFood.m_41777_();
        ItemStack consumedResult = foodCopy.m_41720_().m_5922_(foodCopy, level, livingEntity);
        boolean shouldConsume = true;
        if (ItemStack.m_150942_((ItemStack)originalFood, (ItemStack)consumedResult) && consumedResult.m_41613_() >= originalFood.m_41613_()) {
            shouldConsume = false;
        }
        if (shouldConsume) {
            Player player;
            CornucopiaItem.removeOneItem(stack, 0);
            if (!consumedResult.m_41619_() && !ItemStack.m_150942_((ItemStack)originalFood, (ItemStack)consumedResult) && livingEntity instanceof Player && !(player = (Player)livingEntity).m_150109_().m_36054_(consumedResult)) {
                player.m_36176_(consumedResult, false);
            }
        } else {
            this.suitableFood.m_41720_().m_5922_(this.suitableFood, level, livingEntity);
        }
        return stack;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return this.suitableFood.m_41720_().m_6164_(this.suitableFood);
    }

    public int m_8105_(@NotNull ItemStack cornucopia) {
        int useDuration = this.suitableFood.m_41779_();
        System.out.println("suitableFood" + String.valueOf(this.suitableFood));
        System.out.println("useDuration:" + useDuration);
        return useDuration >= 6 ? useDuration - 6 : useDuration;
    }

    public void m_7373_(@NotNull ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{CornucopiaItem.getContentWeight(pStack), CornucopiaItem.getMaxCapacity()}).m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.minecraft.cornucopia.description").m_130938_(style -> style.m_178520_(ITEM_NAME_COLOR)));
        }
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return CornucopiaItem.getContentWeight(pStack) > 0;
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return Math.min(1 + 12 * CornucopiaItem.getContentWeight(pStack) / CornucopiaItem.getMaxCapacity(), 13);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return BAR_COLOR;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        CornucopiaItem.getContents(pStack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, CornucopiaItem.getContentWeight(pStack)));
    }

    public boolean m_142095_() {
        return false;
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

