/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.cornucopia.mixin;

import com.bmt.cornucopia.Config;
import com.bmt.cornucopia.init.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InstrumentItem.class})
public abstract class InstrumentItemMixin
extends Item {
    @Unique
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public InstrumentItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Unique
    private static int mixin_getMaxCapacity() {
        return (Integer)Config.COMMON.goatHornCapacity.get();
    }

    @Unique
    private static int mixin_add(ItemStack pBundleStack, ItemStack pInsertedStack) {
        if (!pInsertedStack.m_41619_() && pInsertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = pBundleStack.m_41784_();
            if (!compoundtag.m_128441_("Items")) {
                compoundtag.m_128365_("Items", (Tag)new ListTag());
            }
            int i = InstrumentItemMixin.mixin_getContentWeight(pBundleStack);
            int j = InstrumentItemMixin.mixin_getWeight(pInsertedStack);
            int k = Math.min(pInsertedStack.m_41613_(), (InstrumentItemMixin.mixin_getMaxCapacity() - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            Optional<CompoundTag> optional = InstrumentItemMixin.mixin_getMatchingItem(pInsertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundTag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundTag1);
                if (k + itemstack.m_41613_() > 64) {
                    int increment = 64 - itemstack.m_41613_();
                    int rest = k - increment;
                    itemstack.m_41769_(increment);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                    ItemStack itemstack1 = pInsertedStack.m_255036_(rest);
                    CompoundTag compoundTag2 = new CompoundTag();
                    itemstack1.m_41739_(compoundTag2);
                    listtag.add(0, (Tag)compoundTag2);
                } else if (k + itemstack.m_41613_() <= 64) {
                    itemstack.m_41769_(k);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                }
            } else {
                ItemStack itemstack1 = pInsertedStack.m_255036_(k);
                CompoundTag compoundTag2 = new CompoundTag();
                itemstack1.m_41739_(compoundTag2);
                listtag.add(0, (Tag)compoundTag2);
            }
            return k;
        }
        return 0;
    }

    @Unique
    private static Optional<CompoundTag> mixin_getMatchingItem(ItemStack pStack, ListTag pList) {
        return pList.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)pStack)).findFirst();
    }

    @Unique
    private static int mixin_getWeight(ItemStack pStack) {
        return 64 / pStack.m_41741_();
    }

    @Unique
    private static int mixin_getContentWeight(ItemStack pStack) {
        return InstrumentItemMixin.mixin_getContents(pStack).mapToInt(itemStack -> InstrumentItemMixin.mixin_getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    @Unique
    private static Optional<ItemStack> mixin_removeOneStack(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            pStack.m_41749_("Items");
        }
        return Optional.of(itemstack);
    }

    @Unique
    private static Stream<ItemStack> mixin_getContents(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public boolean m_142207_(ItemStack pStack, @NotNull Slot pSlot, @NotNull ClickAction pAction, @NotNull Player pPlayer) {
        if (pStack.m_41613_() != 1 || pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        if (itemstack.m_41619_()) {
            this.mixin_playRemoveOneSound((Entity)pPlayer);
            InstrumentItemMixin.mixin_removeOneStack(pStack).ifPresent(itemStack -> InstrumentItemMixin.mixin_add(pStack, pSlot.m_150659_(itemStack)));
        } else if (itemstack.m_41720_().m_142095_() && itemstack.getFoodProperties((LivingEntity)pPlayer) != null) {
            int i = (InstrumentItemMixin.mixin_getMaxCapacity() - InstrumentItemMixin.mixin_getContentWeight(pStack)) / InstrumentItemMixin.mixin_getWeight(itemstack);
            int j = InstrumentItemMixin.mixin_add(pStack, pSlot.m_150647_(itemstack.m_41613_(), i, pPlayer));
            if (j > 0) {
                this.mixin_playInsertSound((Entity)pPlayer);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack pStack, @NotNull ItemStack pOther, @NotNull Slot pSlot, @NotNull ClickAction pAction, @NotNull Player pPlayer, @NotNull SlotAccess pAccess) {
        if (pStack.m_41613_() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            int i;
            if (pOther.m_41619_()) {
                InstrumentItemMixin.mixin_removeOneStack(pStack).ifPresent(itemStack -> {
                    this.mixin_playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(itemStack);
                });
            } else if (pOther.getFoodProperties((LivingEntity)pPlayer) != null && (i = InstrumentItemMixin.mixin_add(pStack, pOther)) > 0) {
                this.mixin_playInsertSound((Entity)pPlayer);
                pOther.m_41774_(i);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (InstrumentItemMixin.mixin_getContentWeight(stack) == InstrumentItemMixin.mixin_getMaxCapacity()) {
            CompoundTag compoundTag;
            ItemStack cornucopiaItemStack = new ItemStack((ItemLike)ModItems.CORNUCOPIA.get());
            if (!((Boolean)Config.COMMON.enableClearFoods.get()).booleanValue() && (compoundTag = stack.m_41783_()) != null) {
                ListTag listTag = compoundTag.m_128437_("Items", 10);
                cornucopiaItemStack.m_41784_().m_128365_("Items", (Tag)listTag);
            }
            return cornucopiaItemStack;
        }
        return stack;
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return InstrumentItemMixin.mixin_getContentWeight(pStack) > 0;
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return Math.min(1 + 12 * InstrumentItemMixin.mixin_getContentWeight(pStack) / InstrumentItemMixin.mixin_getMaxCapacity(), 13);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return BAR_COLOR;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        InstrumentItemMixin.mixin_getContents(pStack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, InstrumentItemMixin.mixin_getContentWeight(pStack)));
    }

    @Inject(method={"appendHoverText"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/InstrumentItem;getInstrument(Lnet/minecraft/world/item/ItemStack;)Ljava/util/Optional;")})
    public void appendHoverTextInject(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced, CallbackInfo info) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{InstrumentItemMixin.mixin_getContentWeight(pStack), InstrumentItemMixin.mixin_getMaxCapacity()}).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.minecraft.goat_horn.description").m_130940_(ChatFormatting.GRAY));
    }

    @Unique
    private void mixin_playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Unique
    private void mixin_playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

