/*
 * Decompiled with CFR 0.152.
 */
package com.connorcode.autoreauth.auth;

import com.connorcode.autoreauth.Main;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.net.Proxy;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_320;
import net.minecraft.class_412;
import net.minecraft.class_4341;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5244;
import net.minecraft.class_5520;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7578;
import net.minecraft.class_7853;
import net.minecraft.class_8496;
import net.minecraft.class_8497;
import net.minecraft.class_8647;

public class AuthUtils {
    public static CompletableFuture<AuthStatus> getAuthStatus() {
        Main.log.info("Checking auth status");
        return CompletableFuture.supplyAsync(() -> {
            class_320 session = Main.client.method_1548();
            String token = session.method_1674();
            String id = UUID.randomUUID().toString();
            YggdrasilMinecraftSessionService sessionService = (YggdrasilMinecraftSessionService)Main.client.method_73361().comp_837();
            try {
                AuthStatus authStatus;
                sessionService.joinServer(Main.client.method_1548().method_44717(), token, id);
                AuthStatus authStatus2 = authStatus = sessionService.hasJoinedServer(session.method_1676(), id, null) != null ? AuthStatus.Online : AuthStatus.Offline;
                if (authStatus.isOnline()) {
                    Main.sentToast = false;
                }
                Main.log.info("Auth status: " + authStatus.getText());
                return authStatus;
            }
            catch (AuthenticationException e) {
                Main.log.info("Invalid auth status");
                return AuthStatus.Invalid;
            }
        });
    }

    public static void setSession(class_320 session) throws AuthenticationException {
        class_4341 realmsClient;
        Main.log.info("Overwriting session with {} ({})", (Object)session.method_1676(), (Object)session.method_44717());
        Main.client.field_1726 = session;
        Main.client.field_17763.field_18934 = session;
        YggdrasilAuthenticationService yggdrasilAuthenticationService = Main.client.method_72704() ? YggdrasilAuthenticationService.createOffline((Proxy)Main.client.method_1487()) : new YggdrasilAuthenticationService(Main.client.method_1487());
        Main.client.field_26902 = yggdrasilAuthenticationService.createUserApiService(session.method_1674());
        Main.client.field_26842 = new class_5520(Main.client, Main.client.field_26902);
        Main.client.field_39068 = class_7853.method_46532((UserApiService)Main.client.field_26902, (class_320)session, (Path)Main.client.field_1697.toPath());
        Main.client.field_39492 = class_7574.method_44599((class_7569)Main.client.field_39492.field_40820, (UserApiService)Main.client.field_26902);
        class_8647.field_45183 = null;
        class_4341.field_57916 = realmsClient = new class_4341(session.method_1675(), session.method_1676(), Main.client);
        Main.client.field_39718 = new class_7578(realmsClient);
    }

    public static void connectToServer(class_639 address, class_642 info, boolean quickPlay) {
        class_412 connectScreen = new class_412((class_437)new class_442(), quickPlay ? class_8496.field_44554 : class_5244.field_26625);
        Main.client.method_18096((class_437)connectScreen, false);
        Main.client.method_38932();
        Main.client.method_44376(class_7569.method_44589((String)(info != null ? info.field_3761 : address.method_2952())));
        Main.client.method_51253().method_51266(class_8497.class_8500.field_44569, info.field_3761, info.field_3752);
        Main.client.method_1507((class_437)connectScreen);
        connectScreen.method_2130(Main.client, address, info, null);
    }

    public static enum AuthStatus {
        Unknown,
        Invalid,
        Online,
        Offline;


        public String getText() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Waiting...";
                case 1 -> "Invalid";
                case 2 -> "Online";
                case 3 -> "Offline";
            };
        }

        public boolean isInvalid() {
            return this != Unknown && this != Online;
        }

        public boolean isOnline() {
            return this == Online;
        }
    }
}

