/*
 * Decompiled with CFR 0.152.
 */
package com.connorcode.autoreauth.auth;

import com.connorcode.autoreauth.Main;
import com.connorcode.autoreauth.Misc;
import com.connorcode.autoreauth.gui.WaitingForLogin;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_320;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.Nullable;

public class MicrosoftAuth {
    public static final String CLIENT_ID = "e16699bb-2aa8-46da-b5e3-45cbcce29091";
    public static final int PORT = 9090;
    public static final String REDIRECT_URI = "http://localhost:9090/callback";
    public static final URI ACCESS_TOKEN_URI = URI.create("https://login.microsoftonline.com/consumers/oauth2/v2.0/token");
    public static final URI XBOX_AUTH_URI = URI.create("https://user.auth.xboxlive.com/user/authenticate");
    public static final URI XSTS_AUTH_URI = URI.create("https://xsts.auth.xboxlive.com/xsts/authorize");
    public static final URI MINECRAFT_AUTH_URI = URI.create("https://api.minecraftservices.com/authentication/login_with_xbox");
    public static final URI PROFILE_URI = URI.create("https://api.minecraftservices.com/minecraft/profile");
    AuthProgressCallback callback;

    public MicrosoftAuth(AuthProgressCallback callback) {
        this.callback = callback;
    }

    public MicrosoftAuth() {
        this.callback = e -> {};
    }

    static JsonElement getIfPresent(JsonObject json, String key, String context) throws AuthException {
        if (!json.has(key)) {
            throw new AuthException(String.format("Missing key '%s' in %s", key, context), null);
        }
        return json.get(key);
    }

    public static CompletableFuture<String> getCode(Semaphore semaphore) {
        return CompletableFuture.supplyAsync(() -> {
            URI uri;
            HttpServer server;
            String state = Misc.randomString(10);
            AtomicReference<String> finalCode = new AtomicReference<String>("");
            try {
                server = HttpServer.create(new InetSocketAddress(9090), 0);
                server.createContext("/callback", ctx -> {
                    List params = URLEncodedUtils.parse((URI)ctx.getRequestURI(), (Charset)StandardCharsets.UTF_8);
                    Map<String, String> map = params.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
                    if (!map.containsKey("code") || !map.containsKey("state")) {
                        ctx.sendResponseHeaders(400, 0L);
                        ctx.getResponseBody().write("Invalid request!\nYou need the code and state parameters.".getBytes());
                        ctx.close();
                        return;
                    }
                    String code = map.get("code");
                    String gotState = map.get("state");
                    if (!gotState.equals(state)) {
                        ctx.sendResponseHeaders(400, 0L);
                        ctx.getResponseBody().write("Invalid state!".getBytes());
                        ctx.close();
                        return;
                    }
                    finalCode.set(code);
                    Main.log.info("Got code: {}", finalCode.get());
                    ctx.sendResponseHeaders(200, 0L);
                    ctx.getResponseBody().write("You can close this tab now.".getBytes());
                    ctx.close();
                    semaphore.release();
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                URIBuilder builder = new URIBuilder("https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize");
                builder.addParameter("client_id", CLIENT_ID);
                builder.addParameter("response_type", "code");
                builder.addParameter("redirect_uri", REDIRECT_URI);
                builder.addParameter("scope", "XboxLive.signin offline_access");
                builder.addParameter("state", state);
                uri = builder.build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            server.start();
            class_156.method_668().method_673(uri);
            Main.client.method_1507((class_437)new WaitingForLogin(Main.client.field_1755, semaphore, uri));
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            server.stop(0);
            if (finalCode.get().isEmpty()) {
                throw new CompletionException(new AbortException());
            }
            return finalCode.get();
        });
    }

    public static void debugLog(String fmt, Object ... args) {
        if (Main.config.debug) {
            Main.log.info(fmt, args);
        }
    }

    public CompletableFuture<class_320> authenticate(String code) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getAccessToken(code).thenCompose(this::authenticateXbox)).thenCompose(this::obtainXstsToken)).thenCompose(this::authenticateMinecraft)).thenCompose(this::createSession);
    }

    public CompletableFuture<class_320> authenticate(AccessToken token) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.refreshAccessToken(token.refreshToken).thenCompose(this::authenticateXbox)).thenCompose(this::obtainXstsToken)).thenCompose(this::authenticateMinecraft)).thenCompose(this::createSession);
    }

    public CompletableFuture<AccessToken> getAccessToken(String code) {
        this.callback.onProgress("Getting access token");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpPost req = new HttpPost(ACCESS_TOKEN_URI);
                req.setHeader("Content-Type", "application/x-www-form-urlencoded");
                req.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", CLIENT_ID), new BasicNameValuePair("code", code), new BasicNameValuePair("redirect_uri", REDIRECT_URI), new BasicNameValuePair("grant_type", "authorization_code"))));
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("Access token response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "access token response from code";
                String access_token = MicrosoftAuth.getIfPresent(json, "access_token", ctx).getAsString();
                String refresh_token = MicrosoftAuth.getIfPresent(json, "refresh_token", ctx).getAsString();
                return new AccessToken(access_token, refresh_token);
            }
            catch (IOException e) {
                throw new AuthException("Failed to get access token from code", e);
            }
        });
    }

    CompletableFuture<AccessToken> refreshAccessToken(String refreshToken) {
        this.callback.onProgress("Getting access token");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpPost req = new HttpPost(ACCESS_TOKEN_URI);
                req.setHeader("Content-Type", "application/x-www-form-urlencoded");
                req.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", CLIENT_ID), new BasicNameValuePair("refresh_token", refreshToken), new BasicNameValuePair("grant_type", "refresh_token"))));
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("Refresh token response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "access token response from refresh token";
                String access_token = MicrosoftAuth.getIfPresent(json, "access_token", ctx).getAsString();
                String refresh_token = MicrosoftAuth.getIfPresent(json, "refresh_token", ctx).getAsString();
                return new AccessToken(access_token, refresh_token);
            }
            catch (IOException e) {
                throw new AuthException("Failed to get access token from refresh token", e);
            }
        });
    }

    CompletableFuture<XboxAuth> authenticateXbox(AccessToken token) {
        this.callback.onProgress("Authenticating Xbox");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpPost req = new HttpPost(XBOX_AUTH_URI);
                req.setHeader("Content-Type", "application/json");
                JsonObject jsonBuilder = new JsonObject();
                JsonObject properties = new JsonObject();
                properties.addProperty("AuthMethod", "RPS");
                properties.addProperty("SiteName", "user.auth.xboxlive.com");
                properties.addProperty("RpsTicket", "d=" + token.accessToken);
                jsonBuilder.add("Properties", (JsonElement)properties);
                jsonBuilder.addProperty("RelyingParty", "http://auth.xboxlive.com");
                jsonBuilder.addProperty("TokenType", "JWT");
                req.setEntity((HttpEntity)new StringEntity(jsonBuilder.toString()));
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("Xbox auth response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "xbox auth response";
                String xbl_token = MicrosoftAuth.getIfPresent(json, "Token", ctx).getAsString();
                String user_hash = MicrosoftAuth.getIfPresent(json, "DisplayClaims", ctx).getAsJsonObject().get("xui").getAsJsonArray().get(0).getAsJsonObject().get("uhs").getAsString();
                return new XboxAuth(xbl_token, user_hash);
            }
            catch (IOException e) {
                throw new AuthException("Failed to authenticate Xbox", e);
            }
        });
    }

    CompletableFuture<XboxAuth> obtainXstsToken(XboxAuth xboxAuth) {
        this.callback.onProgress("Obtaining XSTS token");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpPost req = new HttpPost(XSTS_AUTH_URI);
                req.setHeader("Content-Type", "application/json");
                JsonObject jsonBuilder = new JsonObject();
                JsonObject properties = new JsonObject();
                properties.addProperty("SandboxId", "RETAIL");
                JsonArray userTokens = new JsonArray();
                userTokens.add(xboxAuth.xblToken);
                properties.add("UserTokens", (JsonElement)userTokens);
                jsonBuilder.add("Properties", (JsonElement)properties);
                jsonBuilder.addProperty("RelyingParty", "rp://api.minecraftservices.com/");
                jsonBuilder.addProperty("TokenType", "JWT");
                req.setEntity((HttpEntity)new StringEntity(jsonBuilder.toString()));
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("XSTS auth response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "xsts auth response";
                String xsts_token = MicrosoftAuth.getIfPresent(json, "Token", ctx).getAsString();
                return new XboxAuth(xsts_token, xboxAuth.userHash);
            }
            catch (IOException e) {
                throw new AuthException("Failed to obtain XSTS token", e);
            }
        });
    }

    CompletableFuture<MinecraftAuth> authenticateMinecraft(XboxAuth xstsAuth) {
        this.callback.onProgress("Authenticating Minecraft");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpPost req = new HttpPost(MINECRAFT_AUTH_URI);
                req.setHeader("Content-Type", "application/json");
                JsonObject jsonBuilder = new JsonObject();
                jsonBuilder.addProperty("identityToken", "XBL3.0 x=" + xstsAuth.userHash + ";" + xstsAuth.xblToken);
                req.setEntity((HttpEntity)new StringEntity(jsonBuilder.toString()));
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("Minecraft auth response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "minecraft auth response";
                String access_token = MicrosoftAuth.getIfPresent(json, "access_token", ctx).getAsString();
                return new MinecraftAuth(access_token);
            }
            catch (IOException e) {
                throw new AuthException("Failed to authenticate Minecraft", e);
            }
        });
    }

    CompletableFuture<class_320> createSession(MinecraftAuth minecraftAuth) {
        this.callback.onProgress("Creating session");
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpClient client = HttpClients.createMinimal();
                HttpGet req = new HttpGet(PROFILE_URI);
                req.setHeader("Authorization", "Bearer " + minecraftAuth.accessToken);
                CloseableHttpResponse result = client.execute((HttpUriRequest)req);
                String str = EntityUtils.toString((HttpEntity)result.getEntity());
                MicrosoftAuth.debugLog("Profile response: {}", str);
                JsonObject json = class_3518.method_15285((String)str);
                String ctx = "profile response";
                String id = MicrosoftAuth.getIfPresent(json, "id", ctx).getAsString();
                String name = MicrosoftAuth.getIfPresent(json, "name", ctx).getAsString();
                return new class_320(name, Misc.parseUUID(id), minecraftAuth.accessToken, Optional.empty(), Optional.empty());
            }
            catch (IOException e) {
                throw new AuthException("Failed to create session", e);
            }
        });
    }

    public static interface AuthProgressCallback {
        public void onProgress(String var1);
    }

    static class AuthException
    extends CancellationException {
        @Nullable
        Throwable cause;

        public AuthException(String message, @Nullable Throwable cause) {
            super(message);
            this.cause = cause;
        }

        @Override
        public String toString() {
            return String.format("%s: %s", super.toString(), this.cause == null ? "" : this.cause.toString());
        }
    }

    public record AccessToken(String accessToken, String refreshToken) {
    }

    public record XboxAuth(String xblToken, String userHash) {
    }

    public record MinecraftAuth(String accessToken) {
    }

    public static class AbortException
    extends Exception {
    }
}

