package net.acoyt.acornlib.api.item;

import net.acoyt.acornlib.impl.client.armPose.IArmPose;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_572;

public interface CustomArmPoseItem {
    /// Returns the pose for the holder's main hand when this item is held.
    default IArmPose getMainHandPose(class_1309 holder, class_1799 stack) {
        return holder.method_6047() == stack ? class_572.class_573.field_3410 : class_572.class_573.field_3409;
    }

    /// Returns the pose for the holder's offhand when this item is held.
    default IArmPose getOffHandPose(class_1309 holder, class_1799 stack) {
        return holder.method_6079() == stack ? class_572.class_573.field_3410 : class_572.class_573.field_3409;
    }

    /// Returns any custom pose which this item might apply to the holder. Prioritizes the main hand.
    default IArmPose getCustomPose(class_1309 holder, class_1799 stack) {
        IArmPose mainPose = getMainHandPose(holder, stack);
        IArmPose otherPose = getOffHandPose(holder, stack);

        if (mainPose != null && isCustom(mainPose)) {
            return mainPose;
        } else if (otherPose != null && isCustom(otherPose)) {
            return otherPose;
        }

        return null;
    }

    static IArmPose getCustomPose(class_1309 holder) {
        class_1799 stack = getWeapon(holder);
        if (stack != null) {
            return ((CustomArmPoseItem) stack.method_7909()).getCustomPose(holder, stack);
        }
        return null;
    }

    /// Returns any CustomArmPoseItem which the holder might be holding. Prioritizes the main hand.
    static class_1799 getWeapon(class_1309 holder) {
        if (holder.method_6047().method_7909() instanceof CustomArmPoseItem) {
            return holder.method_6047();
        } else if (holder.method_6079().method_7909() instanceof CustomArmPoseItem) {
            return holder.method_6079();
        } else {
            return null;
        }
    }

    static boolean isCustom(IArmPose pose) {
        return pose.value() != IArmPose.Value.VANILLA || (pose != class_572.class_573.field_3409 && pose != class_572.class_573.field_3410);
    }
}
