package net.acoyt.acornlib.api.item;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.init.AcornComponents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public interface SupporterFeaturesItem {
    /**
     * Checks If the Player is a General Supporter
     * @param player The Player to check
     * @return If the Player is a Supporter or not
     */
    default boolean isSupporter(class_1657 player) {
        return AcornLib.isSupporter(player);
    }

    /**
     * Gets the Skin from the stack
     * @param stack The stack to check the skin of
     * @return The Skin string
     */
    default String getSkin(@NotNull class_1799 stack) {
        return stack.method_57825(AcornComponents.SKIN, "default");
    }

    /**
     * Sets the Skin for the stack
     * @param stack The stack to change the skin of
     * @param skin The string to set the Skin to
     */
    default void setSkin(@NotNull class_1799 stack, String skin) {
        stack.method_57379(AcornComponents.SKIN, skin);
    }
}
