package net.acoyt.acornlib.impl.block;

import net.acoyt.acornlib.impl.init.AcornBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2619;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9794;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlushBlockEntity extends class_2586 {
    public double squish = 0;

    public PlushBlockEntity(class_2338 pos, class_2680 state) {
        super(AcornBlockEntities.PLUSH, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, @NotNull PlushBlockEntity plush) {
        if (plush.squish > 0.0) {
            plush.squish /= 3.0;
            if (plush.squish < 0.01) {
                plush.squish = 0.0;
                if (world != null) {
                    world.method_8413(pos, state, state, class_2248.field_31028);
                }
            }
        }

        if (world != null && world.method_8321(pos.method_10074()) instanceof class_2619 jukebox) {
            class_9794 manager = jukebox.method_60784();
            if (manager.method_60754() && manager.method_60761() % 7 == 0) {
                plush.squish(1);
            }
        }
    }

    public void squish(int squish) {
        this.squish += squish;
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), class_2248.field_31028);
        }

        this.method_5431();
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10549("squish", this.squish);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.squish = nbt.method_10574("squish");
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return method_38244(registries);
    }
}
