package net.acoyt.acornlib.impl.client.armPose;

import java.util.function.BiConsumer;
import net.minecraft.class_1309;
import net.minecraft.class_630;

public class CustomArmPose implements IArmPose {
    private BiConsumer<class_630, Context> leftArmTransform;
    private BiConsumer<class_630, Context> rightArmTransform;
    private final boolean twoHanded;
    private final boolean preventLimbSwing;

    public CustomArmPose(BiConsumer<class_630, Context> transform, boolean left, boolean preventLimbSwing) {
        if (left) {
            this.leftArmTransform = transform;
        } else {
            this.rightArmTransform = transform;
        }

        this.twoHanded = false;
        this.preventLimbSwing = preventLimbSwing;
    }

    public CustomArmPose(BiConsumer<class_630, Context> leftArmTransform, BiConsumer<class_630, Context> rightArmTransform, boolean preventLimbSwing) {
        this.leftArmTransform = leftArmTransform;
        this.rightArmTransform = rightArmTransform;
        this.twoHanded = true;
        this.preventLimbSwing = preventLimbSwing;
    }

    public void transformLeft(class_630 leftArm, Context ctx) {
        this.leftArmTransform.accept(leftArm, ctx);
    }

    public void transformRight(class_630 rightArm, Context ctx) {
        this.rightArmTransform.accept(rightArm, ctx);
    }

    public boolean preventLimbSwing() {
        return this.preventLimbSwing;
    }

    @Override
    public boolean twoHanded() {
        return this.twoHanded;
    }

    @Override
    public Value value() {
        return Value.CUSTOM;
    }

    public record Context(class_1309 entity, float headPitch, float headYaw, float bodyPitch, float bodyYaw, boolean leftHanded) {
        //
    }
}
