package net.acoyt.acornlib.impl.init;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.client.armPose.CustomArmPose;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import java.util.LinkedHashMap;
import java.util.Map;

public interface AcornArmPoses {
    Map<CustomArmPose, class_2960> POSES = new LinkedHashMap<>();

    CustomArmPose TEST = create("test", new CustomArmPose(
            (leftArm, ctx) -> {
                leftArm.field_3654 = Math.min(ctx.headPitch() + 80.0f, 80.77f);
            },
            (rightArm, ctx) -> {
                rightArm.field_3654 = Math.min(ctx.headPitch() + 80.0f, 80.77f);
            },
            false
    ));

    private static <T extends CustomArmPose> T create(String name, T pose) {
        POSES.put(pose, AcornLib.id(name));
        return pose;
    }

    static void init() {
        POSES.keySet().forEach(armPose -> {
            class_2378.method_10230(AcornRegistries.CUSTOM_ARM_POSE, POSES.get(armPose), armPose);
        });
    }
}
