package net.acoyt.acornlib.impl.init;

import com.mojang.serialization.Codec;
import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.component.HitParticleComponent;
import net.acoyt.acornlib.impl.component.HitSoundComponent;
import net.acoyt.acornlib.impl.component.SweepParticleComponent;
import net.minecraft.class_2378;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.util.function.UnaryOperator;

public interface AcornComponents {
    class_9331<class_3902> TWO_HANDED = create("two_handed", builder -> builder.method_57881(class_3902.field_51563));
    class_9331<class_3902> FOLLOWS_CAM = create("follows_cam", builder -> builder.method_57881(class_3902.field_51563));
    class_9331<class_3902> SHOW_HAND = create("show_hand", builder -> builder.method_57881(class_3902.field_51563));
    class_9331<class_3902> UNDROPPABLE = create("undroppable", builder -> builder.method_57881(class_3902.field_51563));

    class_9331<String> SKIN = create("skin", builder -> builder.method_57881(Codec.STRING));
    //ComponentType<Identifier> SECONDARY_MODEL = create("secondary_model", builder -> builder.codec(Identifier.CODEC));
    //ComponentType<Identifier> TERTIARY_MODEL = create("tertiary_model", builder -> builder.codec(Identifier.CODEC));
    //ComponentType<Identifier> SKIN_LAYER = create("skin_layer", builder -> builder.codec(Identifier.CODEC));

    // Other
    class_9331<HitParticleComponent> HIT_PARTICLE = create("hit_particle", builder -> builder.method_57881(HitParticleComponent.CODEC));
    class_9331<HitSoundComponent> HIT_SOUND = create("hit_sound", builder -> builder.method_57881(HitSoundComponent.CODEC));
    class_9331<SweepParticleComponent> SWEEP_PARTICLE = create("sweep_particle", builder -> builder.method_57881(SweepParticleComponent.CODEC));

    static <T> class_9331<T> create(String name, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(class_7923.field_49658, AcornLib.id(name), (builderOperator.apply(class_9331.method_57873()).method_57880()));
    }

    static void init() {
        //
    }
}
