package net.acoyt.acornlib.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.acoyt.acornlib.api.event.CanConsumeItemEvent;
import net.acoyt.acornlib.api.item.CustomHitParticleItem;
import net.acoyt.acornlib.api.item.CustomHitSoundItem;
import net.acoyt.acornlib.api.item.ShieldBreaker;
import net.acoyt.acornlib.api.util.ParticleUtils;
import net.acoyt.acornlib.impl.client.particle.SweepParticleEffect;
import net.acoyt.acornlib.impl.compat.AcornConfig;
import net.acoyt.acornlib.impl.component.HitParticleComponent;
import net.acoyt.acornlib.impl.component.HitSoundComponent;
import net.acoyt.acornlib.impl.component.SweepParticleComponent;
import net.acoyt.acornlib.impl.init.AcornComponents;
import net.acoyt.acornlib.impl.init.AcornCriterions;
import net.acoyt.acornlib.impl.mixin.client.PlayerEntityRendererMixin;
import net.acoyt.acornlib.impl.util.AcornLibUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6024;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    @Shadow public abstract float getAttackCooldownProgress(float baseTime);

    @Shadow
    public abstract class_1796 getItemCooldownManager();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyReturnValue(
            method = "getDisplayName",
            at = @At("RETURN")
    )
    public class_2561 acornLib$applyFriendFormattingToName(class_2561 original) {
        return AcornConfig.allowSupporterNameColors ? AcornLibUtils.stylizeNames(this.method_5667(), original) : original;
    }

    @Inject(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"
            )
    )
    private void acornlib$spawnCustomHitParticlesAndPlayCustomHitSound(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)(Object)this;
        if (this.getAttackCooldownProgress(0.5F) > 0.9F) {
            class_1792 var4 = this.method_6047().method_7909();
            if (var4 instanceof CustomHitParticleItem hitParticleItem) {
                hitParticleItem.spawnHitParticles(player, target);
            }

            var4 = this.method_6047().method_7909();
            if (var4 instanceof CustomHitSoundItem hitSoundItem) {
                hitSoundItem.playHitSound(player, target);
            }
        }

        if (this.getAttackCooldownProgress(0.5F) > 0.9F) {
            class_1799 stack = this.method_6047();
            if (stack.method_57826(AcornComponents.HIT_PARTICLE)) {
                class_2394 par = class_2398.field_11227;
                if (stack.method_57824(AcornComponents.HIT_PARTICLE) != null) {
                    class_2400 reg = (class_2400)class_7923.field_41180.method_10223(Objects.requireNonNull(stack.method_57824(AcornComponents.HIT_PARTICLE)).particle());
                    if (reg != null) {
                        par = reg;
                    }
                }

                int count = stack.method_57825(AcornComponents.HIT_PARTICLE, HitParticleComponent.DEFAULT).count();

                ParticleUtils.spawnSweepParticles(par, count, player);
            }

            if (stack.method_57826(AcornComponents.SWEEP_PARTICLE)) {
                SweepParticleComponent advHitParticle = stack.method_57824(AcornComponents.SWEEP_PARTICLE);
                assert advHitParticle != null;
                int base = advHitParticle.baseColor();
                int shadow = advHitParticle.shadowColor();

                ParticleUtils.spawnSweepParticles(new SweepParticleEffect(base, shadow), player);
            }

            if (stack.method_57826(AcornComponents.HIT_SOUND)) {
                class_3414 soundEvent = class_3417.field_42593;
                if (stack.method_57824(AcornComponents.HIT_SOUND) != null) {
                    class_3414 event = class_3414.method_47908(stack.method_57825(AcornComponents.HIT_SOUND, HitSoundComponent.DEFAULT).soundEvent());
                    if (event.method_14833() != null) {
                        soundEvent = event;
                    }
                }

                boolean bl = stack.method_57825(AcornComponents.HIT_SOUND, HitSoundComponent.DEFAULT).randomPitch();
                this.method_5783(soundEvent, 1.0F, bl ? (float) (1.0F + player.method_59922().method_43059() / 10f) : 1.0F);
            }
        }
    }

    @Inject(method = "canConsume", at = @At("HEAD"), cancellable = true)
    private void noEat(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)(Object)this;
        class_1799 stack = player.method_6030();
        Boolean original = cir.getReturnValue();
        if (original != null && stack != null) {
            boolean bl = CanConsumeItemEvent.EVENT.invoker().canConsume(player, stack);
            cir.setReturnValue(bl && original);
        }
    }

    @Inject(
            method = "takeShieldHit",
            at = @At("HEAD")
    )
    private void silly(class_1309 attacker, CallbackInfo ci) {
        class_1799 stack = attacker.method_6047();
        if (stack.method_7909() instanceof ShieldBreaker sb) {
            this.getItemCooldownManager().method_7906(class_1802.field_8255, sb.shieldCooldown(stack));
            this.method_6021();
            this.method_37908().method_8421(this, class_6024.field_29998);
        }

    }

    @Inject(
            method = {"attack"},
            at = {@At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V"
            )}
    )
    private void grantCriticalHitCriterion(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)(Object)this;
        if (player instanceof class_3222 serverPlayer) {
            AcornCriterions.CRITICAL_HIT.method_9141(serverPlayer);
        }
    }
}
