package net.acoyt.acornlib.impl.mixin.armPose;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.acoyt.acornlib.api.item.CustomArmPoseItem;
import net.acoyt.acornlib.impl.client.armPose.CustomArmPose;
import net.acoyt.acornlib.impl.client.armPose.CustomArmPosing;
import net.acoyt.acornlib.impl.client.armPose.IArmPose;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3881;
import net.minecraft.class_3882;
import net.minecraft.class_4592;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_572.class)
public abstract class BipedEntityModelMixin<T extends class_1309> extends class_4592<T> implements class_3881, class_3882 {
    @Shadow @Final public class_630 head;
    @Shadow @Final public class_630 body;
    @Shadow @Final public class_630 leftArm;
    @Shadow @Final public class_630 rightArm;
    @Shadow protected abstract class_1306 getPreferredArm(T entity);
    @Shadow protected abstract class_630 getArm(class_1306 arm);
    @Unique private boolean preventLimbSwing = false;

    @Inject(method = "setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/model/BipedEntityModel;animateArms(Lnet/minecraft/entity/LivingEntity;F)V"))
    private void applyArmTransformations(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        class_1799 stack = CustomArmPoseItem.getWeapon(entity);
        if (stack != null) {
            IArmPose mainPose = ((CustomArmPoseItem) stack.method_7909()).getMainHandPose(entity, stack);
            IArmPose otherPose = ((CustomArmPoseItem) stack.method_7909()).getOffHandPose(entity, stack);
            CustomArmPosing.positionLeftArm(entity, otherPose, this.leftArm, this.head.field_3654, this.head.field_3675, this.body.field_3654, this.body.field_3675, entity.method_6068() == class_1306.field_6182);
            CustomArmPosing.positionRightArm(entity, mainPose, this.rightArm, this.head.field_3654, this.head.field_3675, this.body.field_3654, this.body.field_3675, entity.method_6068() == class_1306.field_6182);

            this.preventLimbSwing = (mainPose instanceof CustomArmPose && ((CustomArmPose) mainPose).preventLimbSwing())
                    || (otherPose instanceof CustomArmPose && ((CustomArmPose) otherPose).preventLimbSwing());
        }
    }

    @WrapOperation(method = "setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/model/BipedEntityModel;animateArms(Lnet/minecraft/entity/LivingEntity;F)V"))
    private void preventAttackAnimations(class_572<?> model, T entity, float animationProgress, Operation<Void> original) {
        class_1799 stack = entity.method_6079();
        if (entity.method_6047().method_7960() && stack.method_7909() instanceof CustomArmPoseItem weapon) {
            IArmPose pose = weapon.getCustomPose(entity, stack);
            if (pose != null && pose.twoHanded()) {
                this.field_3447 = 0.0f;
            }
        }

        original.call(model, entity, animationProgress);
    }

    @WrapWithCondition(method = "setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/model/CrossbowPosing;swingArm(Lnet/minecraft/client/model/ModelPart;FF)V"))
    private boolean preventArmSway(class_630 arm, float animationProgress, float sigma) {
        boolean bl = this.preventLimbSwing;
        this.preventLimbSwing = false;
        return !bl;
    }

    @Inject(method = "animateArms", at = @At(value = "TAIL"))
    private void twoHandedAttack(T entity, float animationProgress, CallbackInfo ci) {
        class_1799 stack = entity.method_6047();
        if (stack.method_7909() instanceof CustomArmPoseItem weapon && this.field_3447 > 0.0f) {

            IArmPose pose = weapon.getCustomPose(entity, stack);
            if (pose != null && pose.twoHanded()) {
                class_630 arm = this.getArm(this.getPreferredArm(entity).method_5928());

                float f = 1.0f - this.field_3447;
                f *= f;
                f *= f;
                f = 1.0f - f;
                float g = class_3532.method_15374(f * (float) Math.PI);
                float h = class_3532.method_15374(this.field_3447 * (float) Math.PI) * -(this.head.field_3654 - 0.7f) * 0.75f;
                arm.field_3654 -= g * 1.2f + h;
                arm.field_3675 = arm.field_3675 + this.body.field_3675 * 2.0f;
                arm.field_3674 = arm.field_3674 + class_3532.method_15374(this.field_3447 * (float) Math.PI) * -0.4f;
            }
        }
    }
}
