package net.acoyt.acornlib.impl.mixin.armPose;

import net.acoyt.acornlib.api.item.CustomArmPoseItem;
import net.acoyt.acornlib.impl.client.armPose.IArmPose;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1007.class)
public class PlayerEntityRendererMixin {
    @Inject(method = "getArmPose", at = @At("RETURN"), cancellable = true)
    private static void customVanillaArmPose(class_742 player, class_1268 hand, CallbackInfoReturnable<class_572.class_573> cir) {
        class_1799 stack = player.method_6047().method_7909() instanceof CustomArmPoseItem ? player.method_6047() : player.method_6079();

        if (stack.method_7909() instanceof CustomArmPoseItem weapon) {
            IArmPose mainPose = weapon.getMainHandPose(player, stack);
            IArmPose otherPose = weapon.getOffHandPose(player, stack);

            if (hand == class_1268.field_5808 && mainPose != null && mainPose.value() == IArmPose.Value.VANILLA) {
                cir.setReturnValue((class_572.class_573) mainPose);
            }

            if (hand == class_1268.field_5810 && otherPose != null && otherPose.value() == IArmPose.Value.VANILLA) {
                cir.setReturnValue((class_572.class_573) otherPose);
            }
        }
    }
}
