package net.acoyt.acornlib.impl.mixin.event;

import net.acoyt.acornlib.api.event.RenderOverlayEvent;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;

@Mixin(class_329.class)
public abstract class InGameHudMixin {
    @Shadow
    @Nullable
    protected abstract class_1657 getCameraPlayer();

    @Shadow
    protected abstract void renderOverlay(class_332 context, class_2960 texture, float opacity);

    @Inject(method = "renderMiscOverlays", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getFrozenTicks()I"))
    private void acornlib$miscOverlaysEvent(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        Optional<class_2960> overlayTexture = RenderOverlayEvent.EVENT.invoker().getOverlay(getCameraPlayer());
        overlayTexture.ifPresent(tex -> this.renderOverlay(context, tex, 1.0F));
    }
}
