package net.acoyt.acornlib.impl.mixin.event;

import net.acoyt.acornlib.api.event.CanConsumeItemEvent;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "canConsume", at = @At("HEAD"), cancellable = true)
    private void noEat(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)(Object)this;
        class_1799 stack = player.method_6030();
        Boolean original = cir.getReturnValue();
        if (original != null && stack != null) {
            boolean bl = CanConsumeItemEvent.EVENT.invoker().canConsume(player, stack);
            cir.setReturnValue(bl && original);
        }
    }
}
