package net.acoyt.acornlib.impl.mixin.modMenu;

import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import net.acoyt.acornlib.api.ALib;
import net.acoyt.acornlib.impl.compat.AcornConfig;
import net.acoyt.acornlib.impl.compat.NameColorList;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ModsScreen.class)
public abstract class ModMenuEntryMixin extends class_437 {
    @Shadow(remap = false) private ModListEntry selected;
    @Shadow(remap = false) private int rightPaneX;

    protected ModMenuEntryMixin(class_2561 title) {
        super(title);
    }

    @Inject(
            method = "render",
            at = @At("TAIL")
    )
    public void render(class_332 drawContext, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            int imageOffset = 36;
            class_2561 name = class_2561.method_43470(mod.getTranslatedName());
            class_5348 trimmedName = name;
            int maxNameWidth = this.field_22789 - (x + imageOffset);
            if (this.field_22793.method_27525(name) > maxNameWidth) {
                class_5348 ellipsis = class_5348.method_29430("...");
                trimmedName = class_5348.method_29433(this.field_22793.method_1714(name, maxNameWidth - this.field_22793.method_27525(ellipsis)), ellipsis);
            }

            // ModMenu Color Set
            for (String modId : ALib.MMM.keySet()) {
                if (modId.equals(mod.getId())) {
                    drawContext.method_35720(this.field_22793, class_2477.method_10517().method_30934(trimmedName), x + imageOffset, 49, ALib.MMM.get(modId));
                }
            }

            // Builtin ModMenu Compat Colors
            if (AcornConfig.nameColorCompat) {
                for (String modId : NameColorList.SPECIAL_MMM.keySet()) {
                    if (modId.equals(mod.getId())) {
                        drawContext.method_35720(this.field_22793, class_2477.method_10517().method_30934(trimmedName), x + imageOffset, 49, NameColorList.SPECIAL_MMM.get(modId));
                    }
                }
            }

            // Author-Specific
            for (String author : NameColorList.AUTHOR_SPECIFIC.keySet()) {
                if (mod.getAuthors().contains(author) && !NameColorList.SPECIAL_MMM.containsKey(mod.getId()) && !ALib.MMM.containsKey(mod.getId())) {
                    drawContext.method_35720(this.field_22793, class_2477.method_10517().method_30934(trimmedName), x + imageOffset, 49, NameColorList.AUTHOR_SPECIFIC.get(author));
                }
            }
        }
    }
}
