package net.acoyt.acornlib;

import net.acoyt.acornlib.init.*;
import net.acoyt.acornlib.item.KillEffectItem;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public class AcornLib implements ModInitializer {
	public static final String MOD_ID = "acornlib";

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	public void onInitialize() {
		AcornBlocks.init();
		AcornItems.init();
		AcornSounds.init();

		AcornComponents.init();

		// Post Kill Effect
		ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
			if (entity instanceof class_1309 livingEntity && livingEntity.method_6047().method_7909() instanceof KillEffectItem killEffectItem) {
				killEffectItem.killEntity(world, livingEntity.method_6047(), livingEntity, killedEntity);
			}
		});
	}
}