package net.acoyt.acornlib;

import net.acoyt.acornlib.datagen.AcornLibBlockLootTableGen;
import net.acoyt.acornlib.datagen.AcornLibBlockTagGen;
import net.acoyt.acornlib.datagen.AcornLibLangGen;
import net.acoyt.acornlib.datagen.AcornLibModelGen;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;

public class AcornLibDatagen implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator dataGenerator) {
        FabricDataGenerator.Pack pack = dataGenerator.createPack();

        pack.addProvider(AcornLibModelGen::new);
        pack.addProvider(AcornLibBlockTagGen::new);
        pack.addProvider(AcornLibLangGen::new);
        pack.addProvider(AcornLibBlockLootTableGen::new);
    }
}
