package net.acoyt.acornlib.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.acoyt.acornlib.init.AcornComponents;
import net.acoyt.acornlib.util.RequiredComponents;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;

@Mixin({class_1856.class})
public abstract class IngredientMixin implements RequiredComponents {
    @Unique
    private String acornLib$requiredCraftingID = "";
    @Unique
    private boolean acornLib$hasRequiredCraftingID = true;

    public IngredientMixin() {
    }

    @Shadow
    public abstract boolean isEmpty();

    @Unique
    public abstract class_1799[] getMatchingStacks();

    public String acornLib$getCraftRequirement() {
        return this.acornLib$requiredCraftingID;
    }

    public void acornLib$setCraftRequirement(String name) {
        this.acornLib$requiredCraftingID = name;
    }

    @Unique
    public String getCraftRequirementComponent(class_1799 item) {
        return item.method_57353().method_57832(AcornComponents.CRAFT_REQUIREMENT) ? (String)item.method_57353().method_57829(AcornComponents.CRAFT_REQUIREMENT) : "";
    }

    @Inject(
            method = {"test(Lnet/minecraft/item/ItemStack;)Z"},
            at = {@At("RETURN")}
    )
    private void acornLib$checkIngredientMatch(class_1799 item, CallbackInfoReturnable<Boolean> cir) {
        if (item != null && !this.isEmpty()) {
            String inputRequirement = this.getCraftRequirementComponent(item);
            class_1799[] stacks = this.getMatchingStacks();
            String ingredientRequirement = stacks.length > 0 ? this.getCraftRequirementComponent(stacks[0]) : "";
            this.acornLib$hasRequiredCraftingID = Objects.equals(ingredientRequirement, inputRequirement);
        }

    }

    @ModifyReturnValue(
            method = {"test(Lnet/minecraft/item/ItemStack;)Z"},
            at = {@At("RETURN")}
    )
    private boolean acornLib$ingredientMatch(boolean original) {
        return original && this.acornLib$hasRequiredCraftingID;
    }
}
