package net.acoyt.acornlib.mixin.client;

import net.acoyt.acornlib.init.AcornComponents;
import net.minecraft.class_1007;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("unchecked")
@Mixin({class_1007.class})
public abstract class PlayerEntityRendererMixin extends class_922 {
    public PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_583 model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(
            method = "getArmPose(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/util/Arm;)Lnet/minecraft/client/render/entity/model/BipedEntityModel$ArmPose;",
            at = {@At("HEAD")},
            cancellable = true
    )
    private static void skylight$twoHandedPoses(class_742 player, class_1306 arm, CallbackInfoReturnable<class_572.class_573> cir) {
        class_1799 main = player.method_6047();
        class_1799 other = player.method_6079();

        // Two-Handed Poses, Objectively the most helpful, Normal Two-Handed is favored, due to it being highest on the chart/list.
        if (Boolean.TRUE.equals(main.method_57353().method_57829(AcornComponents.TWO_HANDED)) || Boolean.TRUE.equals(other.method_57353().method_57829(AcornComponents.TWO_HANDED))) {
            cir.setReturnValue(class_572.class_573.field_3405);
        } else if (Boolean.TRUE.equals(main.method_57353().method_57829(AcornComponents.FOLLOWS_CAM)) || Boolean.TRUE.equals(other.method_57353().method_57829(AcornComponents.FOLLOWS_CAM))) {
            cir.setReturnValue(class_572.class_573.field_3408);
        } else if (Boolean.FALSE.equals(main.method_57353().method_57829(AcornComponents.TWO_HANDED)) || Boolean.FALSE.equals(other.method_57353().method_57829(AcornComponents.TWO_HANDED)) || Boolean.FALSE.equals(main.method_57353().method_57829(AcornComponents.FOLLOWS_CAM)) || Boolean.FALSE.equals(other.method_57353().method_57829(AcornComponents.FOLLOWS_CAM))) {
            return;
        } else {
            return;
        }
    }
}

