package net.acoyt.acornlib.api;

import net.acoyt.acornlib.api.plush.PlushData;
import net.acoyt.acornlib.impl.util.AcornLibUtils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unused")
public final class ALib {
    private static boolean IS_SUPPORTER_REQUIRED = false;
    public static Map<String, Integer> MMM = new HashMap<>(); // Mod Menu Map
    public static Map<String, class_2960> MM_ICONS = new HashMap<>();
    public static Map<String, class_2960> MM_MORE_ICONS = new HashMap<>();
    public static List<PlushData> plushies = new ArrayList<>();

    public static void setSupporterRequired(boolean supporterRequired) {
        IS_SUPPORTER_REQUIRED = supporterRequired;
    }

    public static boolean getSupporterRequired() {
        return IS_SUPPORTER_REQUIRED;
    }

    public static void registerModMenu(String modId, String hexColor) {
        MMM.put(modId, AcornLibUtils.convertToHex(hexColor));
    }

    public static void registerModMenu(String modId, int decimalColor) {
        MMM.put(modId, decimalColor);
    }

    public static void registerPlush(class_2248 block, class_3414 soundEvent, int descColor) {
        PlushData assembledData = new PlushData(block, soundEvent, descColor);
        if (!plushies.contains(assembledData)) {
            plushies.add(assembledData);
        }
    }

    /// If mod already has an icon, add a secondary icon
    public static void registerModIcon(String modId, class_2960 texturePath) {
        if (MM_ICONS.containsKey(modId)) {
            MM_MORE_ICONS.put(modId, texturePath);
        } else {
            MM_ICONS.put(modId, texturePath);
        }
    }

    /// Registers two mod icons
    public static void registerModIcons(String modId, class_2960 mainTexture, class_2960 secondaryTexture) {
        MM_ICONS.put(modId, mainTexture);
        MM_MORE_ICONS.put(modId, secondaryTexture);
    }
}
