package net.acoyt.acornlib.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import java.util.*;

public interface RenderSkinLayerEvent {
    Event<RenderSkinLayerEvent> EVENT = EventFactory.createArrayBacked(RenderSkinLayerEvent.class, events -> player -> {
        List<RenderSkinLayerEvent> sortedEvents = new ArrayList<>(Arrays.asList(events));
        sortedEvents.sort(Comparator.comparingInt(RenderSkinLayerEvent::getPriority));
        for (RenderSkinLayerEvent event : sortedEvents) {
            Optional<class_2960> overlay = event.getLayer(player);
            if (overlay.isPresent()) {
                return overlay;
            }
        }

        return Optional.empty();
    });

    default int getPriority() {
        return 1000;
    }

    Optional<class_2960> getLayer(class_1657 player);
}
