package net.acoyt.acornlib.api.plush;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_3414;

public record PlushData(class_2248 block, class_3414 soundEvent, int descColor) {
    public static final Codec<PlushData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2248.field_46280.fieldOf("block").forGetter(PlushData::block),
            class_3414.field_41698.fieldOf("soundEvent").forGetter(PlushData::soundEvent),
            Codec.INT.fieldOf("descColor").forGetter(PlushData::descColor)
    ).apply(instance, PlushData::new));

    public PlushData withSound(class_3414 soundEvent) {
        return new PlushData(this.block, soundEvent, this.descColor);
    }

    public PlushData withColor(int descColor) {
        return new PlushData(this.block, this.soundEvent, this.descColor);
    }
}
