package net.acoyt.acornlib.api.util;

import com.mojang.serialization.Codec;
import org.joml.Vector3f;

import java.util.List;
import net.minecraft.class_156;

import static net.minecraft.class_5253.class_5254.*;
import static net.minecraft.class_5253.method_59553;

public class PortingUtils {
    public static final Codec<Vector3f> VECTOR_3F = Codec.FLOAT
            .listOf()
            .comapFlatMap(
                    list -> class_156.method_33141(list, 3).map(listX -> new Vector3f(listX.get(0), listX.get(1), listX.get(2))),
                    vec3f -> List.of(vec3f.x(), vec3f.y(), vec3f.z())
            );

    public static final Codec<Integer> RGB = Codec.withAlternative(Codec.INT, VECTOR_3F, vec3f -> fromFloats(1.0F, vec3f.x(), vec3f.y(), vec3f.z()));

    public static int fromFloats(float alpha, float red, float green, float blue) {
        return method_27764(method_59553(alpha), method_59553(red), method_59553(green), method_59553(blue));
    }

    public static Vector3f toVector(int rgb) {
        float f = method_27765(rgb) / 255.0F;
        float g = method_27766(rgb) / 255.0F;
        float h = method_27767(rgb) / 255.0F;
        return new Vector3f(f, g, h);
    }
}
