package net.acoyt.acornlib.api.util;

import net.minecraft.class_1309;
import net.minecraft.class_243;

/// Because Myth was really vague
@SuppressWarnings("unused")
public class VelocityUtils {
    /**
     * @param living The entity to apply the velocity to
     * @param multiplier the multiplier
     * @param inverted whether the multiplier should be inverted or not
     */
    public static void applyVelocityInLookDirection(class_1309 living, float multiplier, boolean inverted) {
        living.method_18800(
                living.method_5720().field_1352 * (inverted ? -multiplier : multiplier),
                living.method_5720().field_1351 * (inverted ? -multiplier : multiplier),
                living.method_5720().field_1350 * (inverted ? -multiplier : multiplier)
        );
        living.field_6037 = true;
    }

    /**
     * @param living The entity to apply the velocity to
     * @param xMulti The X multiplier
     * @param yMulti The Y multiplier
     * @param zMulti The Z multiplier
     * @param inverted whether the multiplier should be inverted or not
     */
    public static void applyVelocityInLookDirection(class_1309 living, float xMulti, float yMulti, float zMulti, boolean inverted) {
        living.method_18800(
                living.method_5720().field_1352 * (inverted ? -xMulti : xMulti),
                living.method_5720().field_1351 * (inverted ? -yMulti : yMulti),
                living.method_5720().field_1350 * (inverted ? -zMulti : zMulti)
        );
        living.field_6037 = true;
    }

    /**
     * @param living The entity to apply the velocity to
     * @param velocity the Vec3d velocity to apply
     */
    public static void applyExactVelocity(class_1309 living, class_243 velocity, boolean inverted) {
        living.method_18799(velocity);
        living.field_6037 = true;
    }

    /**
     * @param living The entity to apply the velocity to
     * @param x the x velocity to apply
     * @param y the y velocity to apply
     * @param z the z velocity to apply
     */
    public static void applyExactVelocity(class_1309 living, double x, double y, double z, boolean inverted) {
        living.method_18800(
                inverted ? -x : x,
                inverted ? -y : y,
                inverted ? -z : z
        );
        living.field_6037 = true;
    }

    /**
     * Sets the velocity of the target to the position of the byEntity minus the target's position times the multiplier
     * target.setVelocity(byEntity.getPos().subtract(target.getPos()).multiply(multiplier));
     * @param target The entity to apply the velocity to
     * @param byEntity the entity to "measure" this multiplier by
     * @param multiplier the multiplier
     * @param inverted whether the multiplier should be inverted or not
     */
    public static void applyVelocityByEntity(class_1309 target, class_1309 byEntity, float multiplier, boolean inverted) {
        target.method_18799(byEntity.method_19538().method_1020(target.method_19538()).method_1021(inverted ? -multiplier : multiplier));
        target.field_6037 = true;
    }
}
