package net.acoyt.acornlib.impl;

import eu.midnightdust.lib.config.MidnightConfig;
import net.acoyt.acornlib.api.ALib;
import net.acoyt.acornlib.api.item.KillEffectItem;
import net.acoyt.acornlib.impl.command.AcornLibCommand;
import net.acoyt.acornlib.impl.command.VelocityCommand;
import net.acoyt.acornlib.impl.compat.AcornConfig;
import net.acoyt.acornlib.impl.init.*;
import net.acoyt.acornlib.impl.util.supporter.SupporterUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.UUID;

public class AcornLib implements ModInitializer {
    public static final SupporterUtils supporters = new SupporterUtils();

    public static final String MOD_ID = "acornlib";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    private static final class_2960 OAK_LEAVES_ID = class_2960.method_60656("blocks/oak_leaves");

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static boolean isSupporter(class_1657 player) {
        return (supporters.isSupporter(player.method_5667()) || supporters.isFriend(player.method_5667())) && !supporters.isBlacklisted(player.method_5667());
    }

    public static boolean isSupporter(UUID uuid) {
        return (supporters.isSupporter(uuid) || supporters.isFriend(uuid)) && !supporters.isBlacklisted(uuid);
    }

    public static boolean isBlacklisted(class_1657 player) {
        return supporters.isBlacklisted(player.method_5667());
    }

    public static boolean isBlacklisted(UUID uuid) {
        return supporters.isBlacklisted(uuid);
    }

    public void onInitialize() {
        new Thread(supporters::fetchPlayers).start();

        ALib.registerModMenu(MOD_ID, 0xFFa83641);

        //AcornRegistries.init();
        //AcornArmPoses.init();
        AcornBlockEntities.init();
        AcornBlocks.init();
        AcornCriterions.init();
        AcornComponents.init();
        AcornItems.init();
        AcornParticles.init();
        AcornSounds.init();

        MidnightConfig.init(MOD_ID, AcornConfig.class);

        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> {
            if (entity instanceof class_3222 player) {
                AcornCriterions.PLAYER_DEATH.method_9141(player);
            }
        });

        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            if (entity instanceof class_3222 player) {
                AcornCriterions.PLAYER_DAMAGE.method_9141(player);
            }
        });

        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
            if (entity instanceof class_1309 livingEntity) {
                if (livingEntity.method_6047().method_7909() instanceof KillEffectItem killEffectItem) {
                    killEffectItem.killEntity(world, livingEntity.method_6047(), livingEntity, killedEntity);
                }
            }
        });

        CommandRegistrationCallback.EVENT.register((dispatcher, acc, dedicated) -> {
            VelocityCommand.register(dispatcher);

            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                AcornLibCommand.register(dispatcher);
            }
        });

        LootTableEvents.MODIFY.register((key, tableBuilder, source, registry) -> {
            if (OAK_LEAVES_ID.equals(key.method_29177())) {
                class_55.class_56 poolBuilder = class_55.method_347()
                        .method_352(class_5662.method_32462(1.0F, 1.0F))
                        .method_356(class_219.method_932(0.05F))
                        .method_351(class_77.method_411(AcornItems.ACORN));

                tableBuilder.method_336(poolBuilder);
            }

            if (class_39.field_38438.equals(key)) {
                class_55.class_56 poolBuilder = class_55.method_347()
                        .method_352(class_5662.method_32462(1.0F, 2.0F))
                        .method_356(class_219.method_932(0.25F))
                        .method_351(class_77.method_411(AcornItems.GOLDEN_ACORN));

                tableBuilder.method_336(poolBuilder);
            }

            if (class_39.field_885.equals(key)) {
                class_55.class_56 poolBuilder = class_55.method_347()
                        .method_352(class_5662.method_32462(1.0F, 2.0F))
                        .method_356(class_219.method_932(0.2F))
                        .method_351(class_77.method_411(AcornItems.GOLDEN_ACORN));

                tableBuilder.method_336(poolBuilder);
            }
        });
    }
}
