package net.acoyt.acornlib.impl.client;

import net.acoyt.acornlib.impl.block.PlushBlockEntity;
import net.acoyt.acornlib.impl.mixin.client.BlockRenderManagerAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class PlushBlockEntityRenderer<T extends class_2586> implements class_827<T> {
    private final class_776 renderManager;

    public PlushBlockEntityRenderer(class_5614.@NotNull class_5615 ctx) {
        this.renderManager = ctx.method_32141();
    }

    @Override
    public void method_3569(@NotNull T entity, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        var squish = entity instanceof PlushBlockEntity plush ? plush.squish : 0;
        var prevSquish = squish * 3;
        var squish2 = (float) Math.pow(1 - 1f / (1f + class_3532.method_16436(tickDelta, prevSquish, squish)), 2);
        matrices.method_22905(1, 1 - squish2, 1);
        matrices.method_22904(0.5, 0, 0.5);
        matrices.method_22905(1 + squish2 / 2, 1, 1 + squish2 / 2);
        matrices.method_22904(-0.5, 0, -0.5);
        var state = entity.method_11010();
        var bakedModel = this.renderManager.method_3349(state);
        ((BlockRenderManagerAccessor) this.renderManager).getModelRenderer().method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_4696.method_23683(state, false)), state, bakedModel, 0xFF, 0xFF, 0xFF, light, overlay);
        matrices.method_22909();
    }
}
