package net.acoyt.acornlib.impl.init;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.block.PlushBlock;
import net.acoyt.acornlib.impl.block.PlushItem;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_4970;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import java.util.function.Function;

public interface AcornBlocks {
    class_2248 ACO_PLUSH = createPlush("aco_plush", PlushBlock::new, 0x8D78CD, class_4970.class_2251.method_9630(class_2246.field_10619)
            .method_22488());

    class_2248 FESTIVE_ACO_PLUSH = createPlush("festive_aco_plush", PlushBlock::new, 0xD54DAB, class_4970.class_2251.method_9630(class_2246.field_10215)
            .method_22488());

    class_2248 CLOWN_ACO_PLUSH = createPlush("clown_aco_plush", PlushBlock::new, 0x1B84C4, class_4970.class_2251.method_9630(class_2246.field_10446)
            .method_22488());

    class_2248 MYTHORICAL_PLUSH = createPlush("mythorical_plush", PlushBlock::new, -1, class_4970.class_2251.method_9630(class_2246.field_10314)
            .method_22488());

    class_2248 GNARP_PLUSH = createPlush("gnarp_plush", PlushBlock::new, -1, class_4970.class_2251.method_9630(class_2246.field_10028)
            .method_22488());

    class_2248 KIO_PLUSH = createPlush("kio_plush", PlushBlock::new, 0x1d171d, class_4970.class_2251.method_9630(class_2246.field_10446)
            .method_22488());

    class_2248 TOAST_PLUSH = createPlush("toast_plush", PlushBlock::new, 0x852c24, class_4970.class_2251.method_9630(class_2246.field_10095)
            .method_22488());

    class_2248 CHEM_PLUSH = createPlush("chem_plush", PlushBlock::new, 0x47091d, class_4970.class_2251.method_9630(class_2246.field_10314)
            .method_22488());

    static class_2248 create(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = factory.apply(settings);
        return class_2378.method_10230(class_7923.field_41175, AcornLib.id(name), block);
    }

    static class_2248 createPlush(String name, Function<class_4970.class_2251, class_2248> factory, int descColor, class_4970.class_2251 settings) {
        class_2248 block = create(name, factory, settings);
        AcornItems.create(name, itemSettings -> new PlushItem(block, itemSettings, descColor), new class_1792.class_1793().equipmentSlot((entity, stack) -> class_1304.field_6169));
        return block;
    }

    static void init() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(AcornBlocks::addFunctionalEntries);
    }

    static void clientInit() {
        BlockRenderLayerMap.INSTANCE.putBlocks(
                class_1921.method_23581(),
                ACO_PLUSH,
                FESTIVE_ACO_PLUSH,
                CLOWN_ACO_PLUSH,
                MYTHORICAL_PLUSH,
                GNARP_PLUSH,
                KIO_PLUSH,
                TOAST_PLUSH
        );
    }

    private static void addFunctionalEntries(FabricItemGroupEntries entries) {
        entries.method_45421(ACO_PLUSH);
        entries.addAfter(ACO_PLUSH, FESTIVE_ACO_PLUSH);
        entries.addAfter(FESTIVE_ACO_PLUSH, CLOWN_ACO_PLUSH);
        entries.addAfter(CLOWN_ACO_PLUSH, MYTHORICAL_PLUSH);
        entries.addAfter(MYTHORICAL_PLUSH, GNARP_PLUSH);
        entries.addAfter(GNARP_PLUSH, KIO_PLUSH);
        entries.addAfter(KIO_PLUSH, TOAST_PLUSH);
    }
}
