package net.acoyt.acornlib.api.util;

import net.acoyt.acornlib.impl.util.AcornLibUtils;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import java.util.List;
import java.util.function.Predicate;

import static net.minecraft.class_9334.field_49633;

@SuppressWarnings("unused")
public class ItemUtils {
    /**
     * Changes a specified item's name to a specified color
     * @param item The Item to modify the Name Color of
     * @param nameColor The Decimal color to change the Item's Name Color to
     */
    public static void modifyItemNameColor(class_1792 item, int nameColor) {
        DefaultItemComponentEvents.MODIFY.register(ctx -> ctx.modify(
                Predicate.isEqual(item),
                (builder, item1) -> builder.method_57840(class_9334.field_50239, class_2561.method_43471(item1.method_7876()).method_54663(nameColor))
        ));
    }

    /**
     * Changes a specified item's name to a specified color
     * @param item The Item to modify the Name Color of
     * @param nameColor The Hex color to change the Item's Name Color to
     */
    public static void modifyItemNameColor(class_1792 item, String nameColor) {
        DefaultItemComponentEvents.MODIFY.register(ctx -> ctx.modify(
                Predicate.isEqual(item),
                (builder, item1) -> builder.method_57840(class_9334.field_50239, class_2561.method_43471(item1.method_7876()).method_54663(AcornLibUtils.convertToHex(nameColor)))
        ));
    }

    /**
     * Modifies the name color of multiple items
     * @param list A list of Items
     * @param nameColor The Decimal color for each of the item's names
     */
    public static void modifyItemNameColors(List<class_1792> list, int nameColor) {
        DefaultItemComponentEvents.MODIFY.register(ctx -> ctx.modify(
                list,
                (builder, item1) -> builder.method_57840(class_9334.field_50239, class_2561.method_43471(item1.method_7876()).method_54663(nameColor))
        ));
    }

    /**
     * Modifies the name color of multiple items
     * @param list A list of Items
     * @param nameColor The Hex color for each of the item's names
     */
    public static void modifyItemNameColors(List<class_1792> list, String nameColor) {
        DefaultItemComponentEvents.MODIFY.register(ctx -> ctx.modify(
                list,
                (builder, item1) -> builder.method_57840(class_9334.field_50239, class_2561.method_43471(item1.method_7876()).method_54663(AcornLibUtils.convertToHex(nameColor)))
        ));
    }

    /**
     * @param stack The ItemStack to check for the specified enchantment
     * @param enchantKey The identifier of the enchantment to check for (etc. "minecraft:silk_touch")
     * @return If the item has the enchantment
     */
    public static boolean hasEnchantment(class_1799 stack, String enchantKey) {
        final var enchantments = stack.method_58695(field_49633, class_9304.field_49385).method_57539();

        for (final var entry : enchantments) {
            String enchant = entry.getKey().method_55840();

            if (enchant.contains(enchantKey)) {
                return true;
            }
        }

        return false;
    }
}
