package net.acoyt.acornlib.api.util;

import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;

public class MiscUtils {
    public static void playSoundForNearbyEntities(class_1937 world, class_243 pos, class_3414 soundEvent, int range, Predicate<? super class_1309> predicate) {
        class_238 box = new class_238(pos.field_1352 - 1, pos.field_1351 - 1, pos.field_1350 - 1, pos.field_1352 + 1, pos.field_1351 + 1, pos.field_1350 + 1);
        box = box.method_1014(range - 1);

        for (class_1309 entity : world.method_8390(class_1309.class, box, predicate)) {
            entity.method_5783(soundEvent, 1.0F, 1.0F);
        }
    }

    public static void playSoundForNearbyEntities(class_1937 world, class_243 pos, class_3414 soundEvent, int range, Predicate<? super class_1309> predicate, float volume, float pitch) {
        class_238 box = new class_238(pos.field_1352 - 1, pos.field_1351 - 1, pos.field_1350 - 1, pos.field_1352 + 1, pos.field_1351 + 1, pos.field_1350 + 1);
        box = box.method_1014(range - 1);

        for (class_1309 entity : world.method_8390(class_1309.class, box, predicate)) {
            entity.method_5783(soundEvent, volume, pitch);
        }
    }

    public static double random(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static float closerTo(float value, float thisFloat, float thatFloat) {
        return Math.abs(value - thisFloat) < Math.abs(value - thatFloat) ? thisFloat : thatFloat;
    }
}
