package net.acoyt.acornlib.impl.client;

import net.acoyt.acornlib.impl.block.PlushBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10889;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

import java.util.List;

@Environment(EnvType.CLIENT)
public class PlushBlockEntityRenderer<T extends class_2586> implements class_827<T> {
    private final class_776 renderManager;

    public PlushBlockEntityRenderer(class_5614.@NotNull class_5615 ctx) {
        this.renderManager = ctx.method_32141();
    }

    @Override
    public void method_3569(T entity, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos) {
        matrices.method_22903();
        double squish = entity instanceof PlushBlockEntity plush ? plush.squish : 0;
        double prevSquish = squish * 3;
        float squish2 = (float) Math.pow(1 - 1f / (1f + class_3532.method_16436(tickProgress, prevSquish, squish)), 2);
        matrices.method_22905(1, 1 - squish2, 1);
        matrices.method_22904(0.5, 0, 0.5);
        matrices.method_22905(1 + squish2 / 2, 1, 1 + squish2 / 2);
        matrices.method_22904(-0.5, 0, -0.5);
        class_2680 state = entity.method_11010();
        List<class_10889> list = this.renderManager.method_3349(state).method_68512(class_5819.method_43049(state.method_26190(entity.method_11016())));
        this.renderManager.method_3350().method_3374(entity.method_10997(), list, state, entity.method_11016(), matrices, vertexConsumers.getBuffer(class_4696.method_29359(state)), false, overlay);
        matrices.method_22909();
    }
}
