package net.acoyt.acornlib.impl.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SpecialSweepAttackParticle extends class_4003 {
    private final class_4002 spriteWithAge;
    private final Vector3f baseColor;
    private final Vector3f shadowColor;

    private SpecialSweepAttackParticle(class_638 world, double x, double y, double z, class_4002 spriteWithAge, SweepParticleEffect particleEffect) {
        super(world, x, y, z, 0.0D, 0.0D, 0.0D);
        this.spriteWithAge = spriteWithAge;
        this.field_3847 = 4;
        this.field_17867 = 1.0F;
        this.method_18142(spriteWithAge);
        this.baseColor = class_9848.method_64963(particleEffect.baseColor());
        this.shadowColor = class_9848.method_64963(particleEffect.shadowColor());
    }

    @Override
    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_18142(this.spriteWithAge);
        }
    }

    @Override
    protected void method_60373(class_4588 vertexConsumer, class_4184 camera, Quaternionf quaternionf, float tickProgress) {
        this.method_18141(this.spriteWithAge.method_18138(this.field_3866, this.field_3847 * 2));
        this.method_3084(this.baseColor.x, this.baseColor.y, this.baseColor.z);
        super.method_60373(vertexConsumer, camera, quaternionf, tickProgress);
        this.method_18141(this.spriteWithAge.method_18138(this.field_3866 + this.field_3847, this.field_3847 * 2));
        this.method_3084(this.shadowColor.x, this.shadowColor.y, this.shadowColor.z);
        super.method_60373(vertexConsumer, camera, quaternionf, tickProgress);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<SweepParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        @Override
        public class_703 createParticle(SweepParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SpecialSweepAttackParticle(world, x, y, z, spriteProvider, parameters);
        }
    }
}
