package net.acoyt.acornlib.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.acoyt.acornlib.api.util.VelocityUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2186;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class VelocityCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("velocity").requires(source -> source.method_9259(2))
                .then(method_9244("targets", class_2186.method_9306())
                        .then(method_9247("exact")
                                .then(method_9244("x", FloatArgumentType.floatArg(0.0f, 999.9f))
                                        .then(method_9244("y", FloatArgumentType.floatArg(0.0f, 999.9f))
                                                .then(method_9244("z", FloatArgumentType.floatArg(0.0f, 999.9f))
                                                        .executes((context) -> {
                                                            for (class_1297 entity : class_2186.method_9317(context, "targets")) {

                                                                float x = FloatArgumentType.getFloat(context, "x");
                                                                float y = FloatArgumentType.getFloat(context, "y");
                                                                float z = FloatArgumentType.getFloat(context, "z");

                                                                if (entity instanceof class_1309 living) {
                                                                    VelocityUtils.applyExactVelocity(living, x, y, z, false);
                                                                }
                                                            }

                                                            return Command.SINGLE_SUCCESS;
                                                        }).then(method_9244("inverted", BoolArgumentType.bool())
                                                                .executes((context) -> {
                                                                    for (class_1297 entity : class_2186.method_9317(context, "targets")) {
                                                                        boolean inverted = BoolArgumentType.getBool(context, "inverted");
                                                                        float x = FloatArgumentType.getFloat(context, "x");
                                                                        float y = FloatArgumentType.getFloat(context, "y");
                                                                        float z = FloatArgumentType.getFloat(context, "z");

                                                                        if (entity instanceof class_1309 living) {
                                                                            VelocityUtils.applyExactVelocity(living, x, y, z, inverted);
                                                                        }
                                                                    }

                                                                    return Command.SINGLE_SUCCESS;
                                                                })
                                                        )
                                                )
                                        )
                                )
                        ).then(method_9247("directional")
                                .then(method_9244("x", FloatArgumentType.floatArg(0.0f, 999.9f))
                                        .then(method_9244("y", FloatArgumentType.floatArg(0.0f, 999.9f))
                                                .then(method_9244("z", FloatArgumentType.floatArg(0.0f, 999.9f))
                                                        .executes((context) -> {
                                                            for (class_1297 entity : class_2186.method_9317(context, "targets")) {

                                                                float x = FloatArgumentType.getFloat(context, "x");
                                                                float y = FloatArgumentType.getFloat(context, "y");
                                                                float z = FloatArgumentType.getFloat(context, "z");

                                                                if (entity instanceof class_1309 living) {
                                                                    VelocityUtils.applyVelocityInLookDirection(living, x, y, z, false);
                                                                }
                                                            }

                                                            return Command.SINGLE_SUCCESS;
                                                        }).then(method_9244("inverted", BoolArgumentType.bool())
                                                                .executes((context) -> {
                                                                    for (class_1297 entity : class_2186.method_9317(context, "targets")) {
                                                                        boolean inverted = BoolArgumentType.getBool(context, "inverted");
                                                                        float x = FloatArgumentType.getFloat(context, "x");
                                                                        float y = FloatArgumentType.getFloat(context, "y");
                                                                        float z = FloatArgumentType.getFloat(context, "z");

                                                                        if (entity instanceof class_1309 living) {
                                                                            VelocityUtils.applyVelocityInLookDirection(living, x, y, z, inverted);
                                                                        }
                                                                    }

                                                                    return Command.SINGLE_SUCCESS;
                                                                })
                                                        )
                                                )
                                        )
                                )
                        ).then(method_9247("byEntity")
                                .then(method_9244("anchor", class_2186.method_9309())
                                        .then(method_9244("multiplier", FloatArgumentType.floatArg(0.1F))
                                                .executes(context -> {
                                                    for (class_1297 target : class_2186.method_9317(context, "targets")) {
                                                        class_1297 entity = class_2186.method_9313(context, "anchor");
                                                        float multiplier = FloatArgumentType.getFloat(context, "multiplier");

                                                        if (target instanceof class_1309 livingTarget && entity instanceof class_1309 livingEntity) {
                                                            VelocityUtils.applyVelocityByEntity(livingTarget, livingEntity, multiplier, false);
                                                        }
                                                    }

                                                    return Command.SINGLE_SUCCESS;
                                                }).then(method_9244("inverted", BoolArgumentType.bool())
                                                        .executes(context -> {
                                                            for (class_1297 target : class_2186.method_9317(context, "targets")) {
                                                                class_1297 entity = class_2186.method_9313(context, "anchor");
                                                                float multiplier = FloatArgumentType.getFloat(context, "multiplier");
                                                                boolean inverted = BoolArgumentType.getBool(context, "inverted");

                                                                if (target instanceof class_1309 livingTarget && entity instanceof class_1309 livingEntity) {
                                                                    VelocityUtils.applyVelocityByEntity(livingTarget, livingEntity, multiplier, inverted);
                                                                }
                                                            }

                                                            return Command.SINGLE_SUCCESS;
                                                        })
                                                )
                                        )
                                )
                        )
                )
        );
    }
}
