package net.acoyt.acornlib.impl.index;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.item.TestItem;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10128;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;

public interface AcornItems {
    class_1792 ACORN = create("acorn", class_1792::new, new class_1792.class_1793()
            .method_7889(16)
            .method_19265(new class_4174(3, 5.0F, false)));

    class_1792 GOLDEN_ACORN = create("golden_acorn", class_1792::new, new class_1792.class_1793()
            .method_7889(8)
            .method_7894(class_1814.field_8903)
            .method_57349(class_9334.field_49641, true)
            .method_24359()
            .method_62833(new class_4174(5, 7.0F, true), class_10128.field_53786));

    @Nullable class_1792 TEST_ITEM = createDev("test_item", TestItem::new, new class_1792.class_1793()
            .method_57349(class_9334.field_49641, true));

    // Create and Register always
    static class_1792 create(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return class_1802.method_51348(class_5321.method_29179(class_7924.field_41197, AcornLib.id(name)), factory, settings);
    }

    // Create and Register when compat mod is loaded, or if the current instance is a development environment, else return null
    static @Nullable class_1792 createCompat(String name, String modId, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return FabricLoader.getInstance().isModLoaded(modId) || FabricLoader.getInstance().isDevelopmentEnvironment() ? create(name, factory, settings) : null;
    }

    // Create and Register if the current instance is a development environment, else return null
    static @Nullable class_1792 createDev(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return FabricLoader.getInstance().isDevelopmentEnvironment() ? create(name, factory, settings) : null;
    }

    static void init() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(entries -> {
            entries.method_45421(ACORN);
            entries.method_45421(GOLDEN_ACORN);
        });

        // If the current instance is a development environment (the test item is not null), then add it to the item group
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(entries -> {
            if (TEST_ITEM != null) {
                entries.method_45421(TEST_ITEM);
            }
        });
    }
}
