package net.acoyt.acornlib.impl.mixin;

import net.acoyt.acornlib.api.effect.UnclearableEffect;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_3043;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;

@Mixin(class_3043.class)
public class EffectCommandMixin {
    @Inject(method = "executeClear(Lnet/minecraft/server/command/ServerCommandSource;Ljava/util/Collection;)I", at = @At("TAIL"))
    private static void resetEffectInstance(class_2168 source, Collection<? extends class_1297> targets, CallbackInfoReturnable<Integer> cir) {
        for (class_1297 entity : targets) {
            if (entity instanceof class_1309 living) {
                for (class_1293 instance : living.method_6088().values()) {
                    if (instance.method_5579().comp_349() instanceof UnclearableEffect) {
                        living.method_6016(instance.method_5579());
                    }
                }
            }
        }
    }

    @Inject(method = "executeClear(Lnet/minecraft/server/command/ServerCommandSource;Ljava/util/Collection;Lnet/minecraft/registry/entry/RegistryEntry;)I", at = @At("HEAD"))
    private static void resetEffectInstance(class_2168 source, Collection<? extends class_1297> targets, class_6880<class_1291> statusEffect, CallbackInfoReturnable<Integer> cir) {
        for (class_1297 entity : targets) {
            if (entity instanceof class_1309 living) {
                for (class_1293 instance : living.method_6088().values()) {
                    if (instance.method_5579().comp_349() instanceof UnclearableEffect) {
                        living.method_6016(instance.method_5579());
                    }
                }
            }
        }
    }
}
