package net.acoyt.acornlib.impl.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.acoyt.acornlib.api.effect.UnclearableEffect;
import net.acoyt.acornlib.api.items.AdvBurningItem;
import net.acoyt.acornlib.api.items.CustomKillSourceItem;
import net.acoyt.acornlib.api.items.KillEffectNoDieItem;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract boolean addStatusEffect(class_1293 effect);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(
            method = "tryUseDeathProtector",
            at = @At("HEAD"),
            cancellable = true
    )
    private void killNoDie(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living = (class_1309)(Object)this;
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309 livingAttacker) {
            class_1799 stack = livingAttacker.method_6047();
            if (stack.method_7909() instanceof KillEffectNoDieItem killNoDie) {
                if (killNoDie.killEntity(livingAttacker.method_37908(), stack, livingAttacker, living)) {
                    cir.setReturnValue(true);
                }
            }
        }
    }

    @Inject(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void impaled$hellforkFix(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker = source.method_5529();
        class_1309 entity = (class_1309)(Object)this;
        if (attacker instanceof class_1309 living && living.method_6047().method_7909() instanceof AdvBurningItem burningItem) {
            entity.method_5639(burningItem.getBurnTime(living.method_6047(), living, entity));
        }
    }

    @WrapOperation(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void silly(class_1309 instance, class_3218 world, class_1282 source, float amount, Operation<Void> original) {
        if (source.method_5529() instanceof class_1309 living && living.method_6047().method_7909() instanceof CustomKillSourceItem killSource) {
            original.call(instance, world, killSource.getKillSource(instance), amount);
        } else {
            original.call(instance, world, source, amount);
        }
    }

    @WrapMethod(method = "clearStatusEffects")
    private boolean preventClear(Operation<Boolean> original) {
        class_1309 living = (class_1309)(Object)this;
        if (!living.method_37908().method_8608()) {
            for (class_1293 instance : living.method_6088().values()) {
                if (instance.method_5579().comp_349() instanceof UnclearableEffect) {
                    boolean result = original.call();
                    this.addStatusEffect(instance);
                    return result;
                }
            }
        }
        return original.call();
    }
}
