package net.acoyt.acornlib.impl.mixin.event;

import net.acoyt.acornlib.api.event.CanEntityHealEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "heal", at = @At("HEAD"), cancellable = true)
    public void cancelHeal(float amount, CallbackInfo ci) {
        class_1309 living = (class_1309)(Object)this;
        if (!CanEntityHealEvent.EVENT.invoker().canEntityHeal(living)) {
            ci.cancel();
        }
    }
}
