package net.acoyt.acornlib.impl.mixin.event;

import net.acoyt.acornlib.api.event.CustomRiptideEvent;
import net.acoyt.acornlib.impl.util.interfaces.PlayerEntityRenderStateAccess;
import net.minecraft.class_10055;
import net.minecraft.class_10169;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_998;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;

@Mixin(class_998.class)
public abstract class TridentRiptideFeatureRendererMixin {
    @Shadow @Final private class_10169 model;

    @Inject(
            method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/PlayerEntityRenderState;FF)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;"
            ),
            cancellable = true
    )
    private void swapHotRiptide(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10055 renderState, float f, float g, CallbackInfo ci) {
        if (renderState instanceof PlayerEntityRenderStateAccess access && renderState.field_53459) {
            class_1657 player = access.acornLib$getPlayerEntity();
            if (player != null) {
                for (class_1268 hand : class_1268.values()) {
                    Optional<class_2960> riptideTexture = CustomRiptideEvent.EVENT.invoker().getRiptideTexture(player, player.method_5998(hand));
                    riptideTexture.ifPresent(texture -> {
                        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578(texture));
                        ci.cancel();
                        this.model.method_63519(renderState);
                        this.model.method_60879(matrixStack, vertexConsumer, i, class_4608.field_21444);
                    });
                }
            }
        }
    }
}
