package net.acoyt.acornlib.impl.mixin.sculk;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_7260;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static net.acoyt.acornlib.impl.util.AcornLibUtils.acoUuid;

@Debug(export = true)
@Mixin(class_7260.class)
public abstract class WardenEntityMixin extends class_1588 {
    @Shadow public abstract class_4095<class_7260> method_18868();

    @Shadow public abstract @Nullable class_1309 method_5968();

    protected WardenEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyReturnValue(method = "getAngerAtTarget", at = @At("RETURN"))
    private int acornLib$getAngerAtTarget(int original) {
        if (this.method_5968() instanceof class_1657 && this.method_5968().method_5667().equals(acoUuid)) {
            return 0;
        }

        return original;
    }

    @Inject(method = "getTarget", at = @At("HEAD"), cancellable = true)
    private void acornLib$getTarget(CallbackInfoReturnable<class_1309> cir) {
        if (this.method_59664() instanceof class_1657 && this.method_59664().method_5667().equals(acoUuid)) {
            cir.setReturnValue(null);
        }
    }

    @ModifyVariable(
            method = "addDarknessToClosePlayers",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/effect/StatusEffectUtil;addEffectToPlayersWithinDistance(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;DLnet/minecraft/entity/effect/StatusEffectInstance;I)Ljava/util/List;"),
            argsOnly = true
    )
    private static class_1297 acornLib$addDarknessToClosePlayers(class_1297 entity) {
        return entity instanceof class_1657 && entity.method_5667().equals(acoUuid) ? null : entity;
    }

    @Inject(method = "tryAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ai/brain/task/SonicBoomTask;cooldown(Lnet/minecraft/entity/LivingEntity;I)V"), cancellable = true)
    private void acornLib$tryAttack(class_3218 world, class_1297 target, CallbackInfoReturnable<Boolean> cir) {
        if (target instanceof class_1657 && target.method_5667().equals(acoUuid)) {
            cir.setReturnValue(false);
            cir.cancel();
        }
    }

    @Inject(method = "updateAttackTarget", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ai/brain/task/SonicBoomTask;cooldown(Lnet/minecraft/entity/LivingEntity;I)V"), cancellable = true)
    private void acornLib$updateAttackTarget(class_1309 target, CallbackInfo ci) {
        if (target instanceof class_1657 && target.method_5667().equals(acoUuid)) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(
            method = "isValidTarget",
            at = @At("RETURN")
    )
    private boolean acornLib$isValidTarget(boolean original, class_1297 target) {
        return original && !(target instanceof class_1657 && target.method_5667().equals(acoUuid));
    }
}
