/*
 * Decompiled with CFR 0.152.
 */
package net.acoyt.acornlib.util.supporter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.acoyt.acornlib.AcornLib;
import net.acoyt.acornlib.util.AcornLibUtils;
import net.acoyt.acornlib.util.PlayerInfo;
import net.minecraft.class_1657;

public class SupporterUtils {
    public static List<PlayerInfo> list = SupporterUtils.fetchPlayers();

    public static List<PlayerInfo> fetchPlayers() {
        ArrayList<PlayerInfo> players = new ArrayList<PlayerInfo>();
        try {
            URL url = new URL("https://raw.githubusercontent.com/AcoYTMC/Data/main/players.json");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (jsonObject.has("players") && jsonObject.get("players").isJsonArray()) {
                    JsonArray playerArray = jsonObject.getAsJsonArray("players");
                    for (JsonElement element : playerArray) {
                        JsonObject playerObj = element.getAsJsonObject();
                        String uuid = playerObj.get("uuid").getAsString();
                        String username = playerObj.get("username").getAsString();
                        players.add(new PlayerInfo(uuid, username));
                    }
                } else {
                    AcornLib.LOGGER.error("Error: 'players' field is missing, or is not an array!");
                }
                reader.close();
            } else {
                AcornLib.LOGGER.error("HTTP Error: " + connection.getResponseCode());
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return players;
    }

    public static boolean isPlayerSupporter(class_1657 player) {
        for (PlayerInfo playerInfo : SupporterUtils.fetchPlayers()) {
            if (!player.method_5845().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUuidFromSupporter(UUID uuid) {
        for (PlayerInfo playerInfo : SupporterUtils.fetchPlayers()) {
            if (!uuid.toString().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerFriend(class_1657 player) {
        return AcornLibUtils.ACO_FRIENDS.contains(player.method_5667());
    }

    public static boolean isUuidFromFriend(UUID uuid) {
        return AcornLibUtils.ACO_FRIENDS.contains(uuid);
    }
}

