package net.acoyt.acornlib.api.item;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.init.AcornComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("unused")
public class ItemWithSkins extends class_1792 implements SupporterFeaturesItem {
    public final boolean requiresSupporter;
    public final String defaultSkin;

    public ItemWithSkins(class_1793 settings, boolean requiresSupporter, String defaultSkin) {
        super(settings.method_57349(AcornComponents.SKIN, defaultSkin).method_7889(1));
        this.requiresSupporter = requiresSupporter;
        this.defaultSkin = defaultSkin;
    }

    public ItemWithSkins(class_1793 settings, boolean requiresSupporter) {
        super(settings.method_57349(AcornComponents.SKIN, "default").method_7889(1));
        this.requiresSupporter = requiresSupporter;
        this.defaultSkin = "default";
    }

    @Override
    public boolean isSupporter(class_1657 player) {
        return !this.requiresSupporter || AcornLib.isSupporter(player);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (entity instanceof class_1657 player) {
            if (this.requiresSupporter && !this.isSupporter(player)) {
                setSkin(stack, defaultSkin);
            }
        }

        super.method_7888(stack, world, entity, slot);
    }
}
