package net.acoyt.acornlib.impl.init;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.block.PlushBlockEntity;
import net.acoyt.acornlib.impl.client.PlushBlockEntityRenderer;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5616;
import net.minecraft.class_7923;
import java.util.LinkedHashMap;
import java.util.Map;

import static net.acoyt.acornlib.impl.init.AcornBlocks.*;

public interface AcornBlockEntities {
    Map<class_2591<?>, class_2960> BLOCK_ENTITIES = new LinkedHashMap<>();

    class_2591<PlushBlockEntity> PLUSH = create("plush", FabricBlockEntityTypeBuilder
            .create(PlushBlockEntity::new)
            .addBlocks(ACO_PLUSH, FESTIVE_ACO_PLUSH, CLOWN_ACO_PLUSH, MYTHORICAL_PLUSH, GNARP_PLUSH, KIO_PLUSH, TOAST_PLUSH)
            .build());

    private static <T extends class_2586> class_2591<T> create(String name, class_2591<T> blockEntity) {
        BLOCK_ENTITIES.put(blockEntity, AcornLib.id(name));
        return blockEntity;
    }

    static void init() {
        BLOCK_ENTITIES.keySet().forEach(blockEntity -> {
            class_2378.method_10230(class_7923.field_41181, BLOCK_ENTITIES.get(blockEntity), blockEntity);
        });
    }

    static void clientInit() {
        class_5616.method_32144(PLUSH, PlushBlockEntityRenderer::new);
    }
}
