package net.acoyt.acornlib.impl.init;

import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.block.PlushBlock;
import net.acoyt.acornlib.impl.block.PlushItem;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11515;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import java.util.function.Function;

public interface AcornBlocks {
    class_2248 ACO_PLUSH = createWithItem("aco_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10619)
            .method_22488());

    class_2248 FESTIVE_ACO_PLUSH = createWithItem("festive_aco_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10215)
            .method_22488());

    class_2248 CLOWN_ACO_PLUSH = createWithItem("clown_aco_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10446)
            .method_22488());

    class_2248 MYTHORICAL_PLUSH = createWithItem("mythorical_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10314)
            .method_22488());

    class_2248 GNARP_PLUSH = createWithItem("gnarp_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10028)
            .method_22488());

    class_2248 KIO_PLUSH = createWithItem("kio_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10446)
            .method_22488());

    class_2248 TOAST_PLUSH = createWithItem("toast_plush", PlushBlock::new, class_4970.class_2251.method_9630(class_2246.field_10095)
            .method_22488());

    // Create and Register always
    static class_2248 create(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return class_2246.method_63053(class_5321.method_29179(class_7924.field_41254, AcornLib.id(name)), factory, settings);
    }

    // Create and Register if specified mod is loaded or if the current instance is a dev environment
    static class_2248 createCompat(String name, String modId, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return FabricLoader.getInstance().isModLoaded(modId) || FabricLoader.getInstance().isDevelopmentEnvironment() ? create(name, factory, settings) : null;
    }

    // Create and Register with an item, always
    static class_2248 createWithItem(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = create(name, factory, settings);
        AcornItems.create(name, itemSettings -> new PlushItem(block, itemSettings), new class_1792.class_1793().method_64194(class_1304.field_6169).method_63685());
        return block;
    }

    // Create and Register with an item, if specified mod is loaded or if the current instance is a dev environment
    static class_2248 createCompatWithItem(String name, String modId, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return FabricLoader.getInstance().isModLoaded(modId) || FabricLoader.getInstance().isDevelopmentEnvironment() ? createWithItem(name, factory, settings) : null;
    }

    static void init() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(AcornBlocks::addFunctionalEntries);
    }

    static void clientInit() {
        BlockRenderLayerMap.putBlocks(
                class_11515.field_60925,
                ACO_PLUSH,
                FESTIVE_ACO_PLUSH,
                CLOWN_ACO_PLUSH,
                MYTHORICAL_PLUSH,
                GNARP_PLUSH,
                KIO_PLUSH,
                TOAST_PLUSH
        );
    }

    private static void addFunctionalEntries(FabricItemGroupEntries entries) {
        entries.method_45421(ACO_PLUSH);
        entries.addAfter(ACO_PLUSH, FESTIVE_ACO_PLUSH);
        entries.addAfter(FESTIVE_ACO_PLUSH, CLOWN_ACO_PLUSH);
        entries.addAfter(CLOWN_ACO_PLUSH, MYTHORICAL_PLUSH);
        entries.addAfter(MYTHORICAL_PLUSH, GNARP_PLUSH);
        entries.addAfter(GNARP_PLUSH, KIO_PLUSH);
        entries.addAfter(KIO_PLUSH, TOAST_PLUSH);
    }
}
