package net.acoyt.acornlib.impl.init;

import com.mojang.serialization.Codec;
import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.component.SweepParticleComponent;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.acoyt.acornlib.impl.component.HitParticleComponent;
import net.acoyt.acornlib.impl.component.HitSoundComponent;
import java.util.LinkedHashMap;
import java.util.Map;

public interface AcornComponents {
    Map<class_9331<?>, class_2960> COMPONENTS = new LinkedHashMap<>();

    class_9331<class_3902> TWO_HANDED = create("two_handed", new class_9331.class_9332<class_3902>()
            .method_57881(class_3902.field_51563)
            .method_57880());

    class_9331<class_3902> FOLLOWS_CAM = create("follows_cam", new class_9331.class_9332<class_3902>()
            .method_57881(class_3902.field_51563)
            .method_57880());

    class_9331<class_3902> SHOW_HAND = create("show_hand", new class_9331.class_9332<class_3902>()
            .method_57881(class_3902.field_51563)
            .method_57880());

    class_9331<class_3902> UNDROPPABLE = create("undroppable", new class_9331.class_9332<class_3902>()
            .method_57881(class_3902.field_51563)
            .method_57880());

    class_9331<String> SKIN = create("skin", new class_9331.class_9332<String>()
            .method_57881(Codec.STRING)
            .method_57880());

    class_9331<class_2960> SECONDARY_MODEL = create("secondary_model", new class_9331.class_9332<class_2960>()
            .method_57881(class_2960.field_25139)
            .method_57880());

    class_9331<class_2960> TERTIARY_MODEL = create("tertiary_model", new class_9331.class_9332<class_2960>()
            .method_57881(class_2960.field_25139)
            .method_57880());

    // Other
    class_9331<HitParticleComponent> HIT_PARTICLE = create("hit_particle", new class_9331.class_9332<HitParticleComponent>()
            .method_57881(HitParticleComponent.CODEC)
            .method_57880());

    class_9331<HitSoundComponent> HIT_SOUND = create("hit_sound", new class_9331.class_9332<HitSoundComponent>()
            .method_57881(HitSoundComponent.CODEC)
            .method_57880());

    class_9331<SweepParticleComponent> SWEEP_PARTICLE = create("sweep_particle", new class_9331.class_9332<SweepParticleComponent>()
            .method_57881(SweepParticleComponent.CODEC)
            .method_57880());

    static <T extends class_9331<?>> T create(String name, T component) {
        COMPONENTS.put(component, AcornLib.id(name));
        return component;
    }

    static void init() {
        COMPONENTS.keySet().forEach((component) -> {
            class_2378.method_10230(class_7923.field_49658, COMPONENTS.get(component), component);
        });
    }
}
