package net.acoyt.acornlib.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.acoyt.acornlib.impl.client.particle.SweepParticleEffect;
import net.acoyt.acornlib.impl.compat.AcornConfig;
import net.acoyt.acornlib.impl.component.SweepParticleComponent;
import net.acoyt.acornlib.impl.init.AcornComponents;
import net.acoyt.acornlib.impl.init.AcornCriterions;
import net.acoyt.acornlib.api.item.CustomHitParticleItem;
import net.acoyt.acornlib.api.item.CustomHitSoundItem;
import net.acoyt.acornlib.api.item.ShieldBreaker;
import net.acoyt.acornlib.impl.util.AcornLibUtils;
import net.minecraft.class_10707;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.acoyt.acornlib.api.util.ParticleUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    @Shadow public abstract float getAttackCooldownProgress(float baseTime);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyReturnValue(
            method = "getDisplayName",
            at = @At("RETURN")
    )
    public class_2561 acornLib$applyFriendFormattingToName(class_2561 original) {
        return AcornConfig.allowSupporterNameColors ? AcornLibUtils.stylizeNames(this.method_5667(), original) : original;
    }

    @Inject(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"
            )
    )
    private void acornlib$spawnCustomHitParticlesAndPlayCustomHitSound(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)(Object)this;
        if (this.getAttackCooldownProgress(0.5F) > 0.9F) {
            class_1792 var4 = this.method_6047().method_7909();
            if (var4 instanceof CustomHitParticleItem hitParticleItem) {
                hitParticleItem.spawnHitParticles(player, target);
            }

            var4 = this.method_6047().method_7909();
            if (var4 instanceof CustomHitSoundItem hitSoundItem) {
                hitSoundItem.playHitSound(player, target);
            }
        }

        if (this.getAttackCooldownProgress(0.5F) > 0.9F) {
            class_1799 stack = this.method_6047();
            if (stack.method_57826(AcornComponents.HIT_PARTICLE)) {
                class_2394 par = class_2398.field_11227;
                if (stack.method_58694(AcornComponents.HIT_PARTICLE) != null) {
                    class_2400 reg = (class_2400)class_7923.field_41180.method_63535(Objects.requireNonNull(stack.method_58694(AcornComponents.HIT_PARTICLE)).particle());
                    if (reg != null) {
                        par = reg;
                    }
                }

                int count = stack.method_58694(AcornComponents.HIT_PARTICLE).count();

                ParticleUtils.spawnSweepParticles(par, count, player);
            }

            if (stack.method_57826(AcornComponents.SWEEP_PARTICLE)) {
                SweepParticleComponent advHitParticle = stack.method_58694(AcornComponents.SWEEP_PARTICLE);
                assert advHitParticle != null;
                int base = advHitParticle.baseColor();
                int shadow = advHitParticle.shadowColor();

                ParticleUtils.spawnSweepParticles(new SweepParticleEffect(base, shadow), player);
            }

            if (stack.method_57826(AcornComponents.HIT_SOUND)) {
                class_3414 soundEvent = class_3417.field_42593;
                if (stack.method_58694(AcornComponents.HIT_SOUND) != null) {
                    class_3414 event = class_3414.method_47908(stack.method_58694(AcornComponents.HIT_SOUND).soundEvent());
                    if (event.comp_3319() != null) {
                        soundEvent = event;
                    }
                }

                boolean bl = stack.method_58694(AcornComponents.HIT_SOUND).randomPitch();
                this.method_5783(soundEvent, 1.0F, bl ? (float) (1.0F + player.method_59922().method_43059() / 10f) : 1.0F);
            }
        }
    }

    @Inject(
            method = "takeShieldHit",
            at = @At("HEAD")
    )
    private void silly(class_3218 world, class_1309 attacker, CallbackInfo ci) {
        class_1799 stack = attacker.method_6047();
        class_1799 shield = this.method_62821();
        class_10707 component = shield != null ? shield.method_58694(class_9334.field_56396) : null;
        if (stack.method_7909() instanceof ShieldBreaker sb) {
            float cooldown = sb.shieldCooldown();
            if (cooldown > 0.0F && component != null) {
                component.method_67200(world, this, cooldown, shield);
            }
        }

    }

    @Inject(
            method = {"attack"},
            at = {@At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V"
            )}
    )
    private void grantCriticalHitCriterion(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)(Object)this;
        if (player instanceof class_3222 serverPlayer) {
            AcornCriterions.CRITICAL_HIT.method_9141(serverPlayer);
        }
    }
}
