package net.acoyt.acornlib.impl.mixin.modMenu;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import net.acoyt.acornlib.api.ALib;
import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.compat.AcornConfig;
import net.acoyt.acornlib.impl.compat.NameColorList;
import net.minecraft.class_10799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ModListEntry.class)
public abstract class ModMenuMixin {
    @Shadow @Final public Mod mod;
    @Shadow @Final protected class_310 client;

    @Inject(
            method = "render",
            at = @At("TAIL")
    )
    private void modifyModNameColor(class_332 drawContext, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo ci) {
        // Get the mod ID
        String modId = this.mod.getId();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;

        class_2561 name = class_2561.method_43470(this.mod.getTranslatedName());
        class_5348 trimmedName = name;
        int maxNameWidth = rowWidth - iconSize - 3;
        class_327 font = this.client.field_1772;
        if (font.method_27525(name) > maxNameWidth) {
            class_5348 ellipsis = class_5348.method_29430("...");
            trimmedName = class_5348.method_29433(font.method_1714(name, maxNameWidth - font.method_27525(ellipsis)), ellipsis);
        }

        // ModIds
        if (AcornConfig.displayModIds) {
            drawContext.method_25303(font, modId, x + 146, y + 1, ALib.MMM.getOrDefault(modId, 0xFFFFFFFF));
        }

        // ModMenu Color Set
        for (String modIde : ALib.MMM.keySet()) {
            if (modIde.equals(modId)) {
                drawContext.method_35720(font, class_2477.method_10517().method_30934(trimmedName), x + iconSize + 3, y + 1, ALib.MMM.get(modId));
            }
        }

        // AcoYT Badge
        boolean bl = mod.getAuthors().contains("AcoYT");
        if (bl) {
            drawContext.method_25290(class_10799.field_56883, AcornLib.id("acorn.png"), rowWidth - 5, y, 0.0F, 0.0F, 16, 16, 16, 16);
        }

        // ModMenu Icons
        for (String modIde : ALib.MM_ICONS.keySet()) {
            if (modIde.equals(modId)) {
                drawContext.method_25290(class_10799.field_56883, ALib.MM_ICONS.get(modId), rowWidth - (bl ? 17 : 5), y, 0.0F, 0.0F, 16, 16, 16, 16);
            }
        }

        for (String modIde : ALib.MM_MORE_ICONS.keySet()) {
            if (modIde.equals(modId)) {
                drawContext.method_25290(class_10799.field_56883, ALib.MM_MORE_ICONS.get(modId), rowWidth - 29, y, 0.0F, 0.0F, 16, 16, 16, 16);
            }
        }

        // Builtin ModMenu Compat Colors
        if (AcornConfig.nameColorCompat) {
            for (String modIde : NameColorList.SPECIAL_MMM.keySet()) {
                if (modIde.equals(modId)) {
                    drawContext.method_35720(font, class_2477.method_10517().method_30934(trimmedName), x + iconSize + 3, y + 1, NameColorList.SPECIAL_MMM.get(modId));
                }
            }
        }

        // Author-Specific
        for (String author : NameColorList.AUTHOR_SPECIFIC.keySet()) {
            if (mod.getAuthors().contains(author) && !NameColorList.SPECIAL_MMM.containsKey(modId) && !ALib.MMM.containsKey(modId)) {
                drawContext.method_35720(font, class_2477.method_10517().method_30934(trimmedName), x + iconSize + 3, y + 1, NameColorList.AUTHOR_SPECIFIC.get(author));
            }
        }
    }
}
