/*
 * Decompiled with CFR 0.152.
 */
package net.acoyt.acornlib.impl.util.supporter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.acoyt.acornlib.impl.AcornLib;
import net.acoyt.acornlib.impl.util.supporter.PlayerInfo;

public class SupporterUtils {
    private static List<PlayerInfo> cachedSupporters = new ArrayList<PlayerInfo>();
    private static List<PlayerInfo> cachedFriends = new ArrayList<PlayerInfo>();
    private static List<PlayerInfo> cachedBlacklisted = new ArrayList<PlayerInfo>();
    private long lastFetchTime = 0L;

    public List<List<PlayerInfo>> fetchPlayers() {
        long CACHE_DURATION;
        long now = System.currentTimeMillis();
        if (!(now - this.lastFetchTime >= (CACHE_DURATION = 300000L) || cachedSupporters.isEmpty() && cachedFriends.isEmpty() && cachedBlacklisted.isEmpty())) {
            return List.of(cachedSupporters, cachedFriends, cachedBlacklisted);
        }
        ArrayList<PlayerInfo> supporters = new ArrayList<PlayerInfo>();
        ArrayList<PlayerInfo> friends = new ArrayList<PlayerInfo>();
        ArrayList<PlayerInfo> blacklisted = new ArrayList<PlayerInfo>();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://raw.githubusercontent.com/AcoYTMC/Data/main/test.json").openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (SupporterUtils.containsArray(jsonObject, "supporters") && SupporterUtils.containsArray(jsonObject, "friends") && SupporterUtils.containsArray(jsonObject, "blacklisted")) {
                    JsonArray supporterArray = jsonObject.getAsJsonArray("supporters");
                    for (Object element : supporterArray) {
                        JsonObject playerObj = element.getAsJsonObject();
                        String uuid = playerObj.get("uuid").getAsString();
                        String username = playerObj.get("username").getAsString();
                        supporters.add(new PlayerInfo(uuid, username));
                    }
                    JsonArray friendArray = jsonObject.getAsJsonArray("friends");
                    for (JsonElement element : friendArray) {
                        JsonObject playerObj = element.getAsJsonObject();
                        String uuid = playerObj.get("uuid").getAsString();
                        String username = playerObj.get("username").getAsString();
                        friends.add(new PlayerInfo(uuid, username));
                    }
                    JsonArray blacklistArray = jsonObject.getAsJsonArray("blacklisted");
                    for (JsonElement element : blacklistArray) {
                        JsonObject playerObj = element.getAsJsonObject();
                        String uuid = playerObj.get("uuid").getAsString();
                        String username = playerObj.get("username").getAsString();
                        blacklisted.add(new PlayerInfo(uuid, username));
                    }
                    cachedSupporters = supporters;
                    cachedFriends = friends;
                    cachedBlacklisted = blacklisted;
                    this.lastFetchTime = now;
                } else {
                    AcornLib.LOGGER.error("Error: one of the following fields are missing, or are not an array: 'supporters' 'friends' 'blacklisted'");
                }
                reader.close();
            } else {
                AcornLib.LOGGER.error("HTTP Error: {}", (Object)connection.getResponseCode());
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return List.of(cachedSupporters, cachedFriends, cachedBlacklisted);
    }

    private static boolean containsArray(JsonObject jsonObject, String check) {
        return jsonObject.has(check) && jsonObject.get(check).isJsonArray();
    }

    public boolean isSupporter(UUID uuid) {
        for (PlayerInfo playerInfo : this.fetchPlayers().getFirst()) {
            if (!uuid.toString().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }

    public boolean isFriend(UUID uuid) {
        for (PlayerInfo playerInfo : this.fetchPlayers().get(1)) {
            if (!uuid.toString().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklisted(UUID uuid) {
        for (PlayerInfo playerInfo : this.fetchPlayers().get(2)) {
            if (!uuid.toString().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }
}

