/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen.neoforge;

import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.rhm.undertale_death_screen.UndertaleDeathScreenBase;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;

@Mod(value="undertale_death_screen")
public class UndertaleDeathScreenNeoforge {
    public UndertaleDeathScreenNeoforge(IEventBus eventBus, ModContainer container) {
        UndertaleDeathScreenCommon.init(new Impl());
        Impl.register(eventBus);
        if (UndertaleDeathScreenCommon.isConfigSupported()) {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> new IConfigScreenFactory(){

                @NotNull
                public Screen createScreen(@NotNull ModContainer container, @NotNull Screen parent) {
                    return UndertaleDeathScreenNeoforge.this.getConfigScreen(parent);
                }

                @NotNull
                public Screen createScreen(@NotNull Minecraft client, @NotNull Screen parent) {
                    return UndertaleDeathScreenNeoforge.this.getConfigScreen(parent);
                }
            });
        }
    }

    private Screen getConfigScreen(Screen parent) {
        Screen screen = UndertaleDeathScreenCommon.getConfigScreen(parent);
        return screen == null ? parent : screen;
    }

    public static class Impl
    implements UndertaleDeathScreenBase {
        private static final DeferredRegister<SoundEvent> SOUND_EVENT_REGISTRY = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"undertale_death_screen");

        public static void register(IEventBus eventBus) {
            SOUND_EVENT_REGISTRY.register(eventBus);
        }

        @Override
        public Supplier<SoundEvent> registerSoundEvent(String path) {
            return SOUND_EVENT_REGISTRY.register(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)UndertaleDeathScreenCommon.id(path)));
        }

        @Override
        public boolean isModLoaded(String id) {
            return ModList.get().isLoaded(id);
        }

        @Override
        public Path getConfigDir() {
            return FMLPaths.CONFIGDIR.get();
        }
    }
}

