/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = UndertaleDeathScreenCommon.impl.getConfigDir().resolve("undertale_death_screen.json");
    public static final Config INSTANCE = Config.load();
    private ShardRenderStyle style = ShardRenderStyle.ROTATION;
    private boolean musicTurnoff = true;
    private boolean determination = true;
    private boolean centeredHeart = true;
    private boolean centeredHeartAnimation = false;
    private double centeredHeartSpeed = 0.15;
    private double backgroundFadeSpeed = 1.0;
    private boolean dynamicHeart = true;

    private Config() {
    }

    public static Config getDefault() {
        return new Config();
    }

    private static Config load() {
        Config config;
        block8: {
            config = null;
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                    config = (Config)GSON.fromJson((Reader)reader, Config.class);
                }
            }
            catch (JsonSyntaxException | IOException e) {
                UndertaleDeathScreenCommon.logger.error("Failed to load configuration file. Using default values.", e);
            }
        }
        if (config == null) {
            config = Config.getDefault();
        }
        config.centeredHeartSpeed = Math.max(0.1, Math.min(1.0, config.centeredHeartSpeed));
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            UndertaleDeathScreenCommon.logger.error("Failed to save configuration file:", (Throwable)e);
        }
    }

    public boolean getDynamicHeart() {
        return this.dynamicHeart;
    }

    public void setDynamicHeart(boolean value) {
        this.dynamicHeart = value;
    }

    public boolean getDetermination() {
        return this.determination;
    }

    public void setDetermination(boolean value) {
        this.determination = value;
    }

    public double getCenteredHeartSpeed() {
        return this.centeredHeartSpeed;
    }

    public void setCenteredHeartSpeed(double value) {
        this.centeredHeartSpeed = value;
    }

    public boolean getCenteredHeartAnimation() {
        return this.centeredHeartAnimation;
    }

    public void setCenteredHeartAnimation(boolean value) {
        this.centeredHeartAnimation = value;
    }

    public boolean getCenteredHeart() {
        return this.centeredHeart;
    }

    public void setCenteredHeart(boolean value) {
        this.centeredHeart = value;
    }

    public ShardRenderStyle getStyle() {
        return this.style;
    }

    public void setStyle(ShardRenderStyle style) {
        this.style = style;
    }

    public boolean getShouldStopSound() {
        return this.musicTurnoff;
    }

    public void setShouldStopSound(boolean musicTurnoff) {
        this.musicTurnoff = musicTurnoff;
    }

    public double getBackgroundFadeSpeed() {
        return this.backgroundFadeSpeed;
    }

    public void setBackgroundFadeSpeed(double backgroundFadeSpeed) {
        this.backgroundFadeSpeed = backgroundFadeSpeed;
    }

    public static enum ShardRenderStyle implements class_3542
    {
        ANIMATED("animated"),
        ROTATION("rotated");

        private final String name;

        private ShardRenderStyle(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

