/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.rhm.undertale_death_screen.Config;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;

public class HeartPiece {
    public static final ResourceLocation PIECES_TEXTURE_LOCATION = UndertaleDeathScreenCommon.id("undertale_death/heart_pieces");
    public static final int PIECE_TEXTURE_WIDTH = 40;
    public static final int PIECE_TEXTURE_HEIGHT = 20;
    public static final int PIECE_WIDTH = 5;
    public static final int PIECE_HEIGHT = 5;
    public static final int FRAME_DURATION = 4;
    public static final int TOTAL_FRAMES = 8;
    private final boolean animated;
    private final int textureX;
    private final int textureY;
    private final double angularVelocity;
    public float x;
    public float y;
    private double vx;
    private double vy;
    private double rotation;
    private int currentFrame = 0;
    private int frameTickCounter = 0;

    public HeartPiece(float x, float y, double vx, double vy, int textureX, int textureY, double rotation, double angularVelocity) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.textureX = textureX;
        this.textureY = textureY;
        this.rotation = rotation;
        this.angularVelocity = angularVelocity;
        this.animated = Config.INSTANCE.getStyle() == Config.ShardRenderStyle.ANIMATED;
    }

    public void renderTick() {
        this.x += (float)this.vx;
        this.y += (float)this.vy;
        this.vy += 0.1;
        this.vx *= 0.98;
        this.vy *= 0.98;
        this.rotation += this.angularVelocity;
        if (this.rotation >= 360.0) {
            this.rotation -= 360.0;
        } else if (this.rotation < 0.0) {
            this.rotation += 360.0;
        }
        if (this.animated) {
            ++this.frameTickCounter;
            if (this.frameTickCounter >= 4) {
                this.frameTickCounter = 0;
                this.currentFrame = (this.currentFrame + 1) % 8;
            }
        }
    }

    public void render(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(this.x, this.y);
        if (!this.animated) {
            guiGraphics.pose().mul((Matrix3x2fc)new Matrix3x2f().rotation((float)Math.toRadians(this.rotation)));
            guiGraphics.pose().translate(-2.5f, -2.5f);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, PIECES_TEXTURE_LOCATION.withPrefix("textures/gui/sprites/").withSuffix(".png"), 0, 0, this.animated ? (float)(this.currentFrame * 5) : (float)this.textureX, (float)this.textureY, 5, 5, 40, 20);
        guiGraphics.pose().popMatrix();
    }
}

